/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.Primitives;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import java.io.File;

public class Bullet
extends AbstractEntity {
    private static final float MAX_DISTANCE = 1000.0f;
    private static final float SPEED = 20.0f;
    private static Object3D BULLET = null;
    private SimpleVector startPos = null;

    public Bullet() {
        super(BULLET);
        this.setCollisionMode(2);
        this.setVisibility(false);
        this.setSpeed(20.0f);
    }

    public void moveForward() {
        int n;
        if (this.getVisibility() && (n = this.checkForCollision(this.getZAxis(), this.getSpeed())) == -100) {
            super.moveForward();
            if (this.getTransformedCenter().calcSub(this.startPos).length() > 1000.0f) {
                this.disable();
            }
        }
    }

    public void enable() {
        this.setVisibility(true);
    }

    public void disable() {
        this.setVisibility(false);
    }

    public void fire(AbstractEntity abstractEntity) {
        this.align(abstractEntity);
        this.setTranslationMatrix(new Matrix());
        this.setOrigin(abstractEntity.getTransformedCenter());
        this.startPos = abstractEntity.getTransformedCenter();
    }

    static {
        Texture texture = new Texture("textures" + File.separatorChar + "spot.jpg");
        TextureManager.getInstance().addTexture("bullet", texture);
        BULLET = Primitives.getSphere((int)4, (float)2.0f);
        BULLET.setTexture("bullet");
        BULLET.calcTextureWrapSpherical();
        BULLET.build();
    }
}

