/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Camera;
import com.threed.jpct.CollisionListener;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.IPaintListener;
import com.threed.jpct.Loader;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.OcTree;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureInfo;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import com.threed.jpct.util.KeyMapper;
import com.threed.jpct.util.KeyState;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

class AWTCarTest
extends Frame
implements IPaintListener {
    private boolean wireframe = false;
    private FrameBuffer buffer = null;
    private World theWorld = null;
    private TextureManager texMan = null;
    private Camera camera = null;
    private Object3D terrain = null;
    private Car car = null;
    private ProjectileManager bulMan = null;
    private PlantManager plantMan = null;
    private SkidMarkManager skidMan = null;
    private Texture numbers = null;
    private int width = 640;
    private int height = 480;
    private int fps;
    private int lastFps;
    private long totalFps;
    private int pps;
    private int lastPps;
    private boolean isIdle = false;
    private boolean exit = false;
    private boolean left = false;
    private boolean right = false;
    private boolean forward = false;
    private boolean back = false;
    private boolean fire = false;
    private int fireCount = 3;
    private float speed = 0.0f;
    private KeyMapper keyMapper = null;
    private boolean playBenchmark = false;
    private boolean recordBenchmark = false;
    private ArrayList keyStates = new ArrayList();
    private Iterator itty = null;
    private boolean finished = false;
    private long fpsRes = 0L;
    private long time = 0L;
    private boolean reset = false;

    public static void main(String[] stringArray) {
        new AWTCarTest(stringArray);
    }

    private ArrayList loadKeyStates() {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        ArrayList arrayList = null;
        System.out.println("Loading key history...");
        try {
            fileInputStream = new FileInputStream("keys.ser");
            objectInputStream = new ObjectInputStream(fileInputStream);
            arrayList = (ArrayList)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private AWTCarTest(String[] stringArray) {
        char c;
        Config.maxPolysVisible = 10000;
        Config.glAWTCommandQueueSize = 100;
        if (this.playBenchmark) {
            this.keyStates = this.loadKeyStates();
            this.itty = ((AbstractList)this.keyStates).iterator();
        }
        for (c = '\u0000'; c < stringArray.length; ++c) {
            if (stringArray[c].equals("mipmap")) {
                Config.glMipmap = true;
            }
            if (stringArray[c].equals("trilinear")) {
                Config.glTrilinear = true;
            }
            if (stringArray[c].equals("16bit")) {
                Config.glColorDepth = 16;
            }
            try {
                if (stringArray[c].startsWith("width=")) {
                    this.width = Integer.parseInt(stringArray[c].substring(6));
                }
                if (stringArray[c].startsWith("height=")) {
                    this.height = Integer.parseInt(stringArray[c].substring(7));
                }
                if (stringArray[c].startsWith("refresh=")) {
                    Config.glRefresh = Integer.parseInt(stringArray[c].substring(8));
                }
                if (!stringArray[c].startsWith("zbuffer=") || (Config.glZBufferDepth = Integer.parseInt(stringArray[c].substring(8))) != 16) continue;
                Config.glFixedBlitting = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isIdle = false;
        this.totalFps = 0L;
        this.fps = 0;
        this.lastFps = 0;
        this.theWorld = new World();
        this.texMan = TextureManager.getInstance();
        Config.fadeoutLight = false;
        this.theWorld.getLights().setOverbrightLighting(255);
        this.theWorld.getLights().setRGBScale(2);
        this.theWorld.setAmbientLight(25, 30, 30);
        this.theWorld.addLight(new SimpleVector(0.0f, -150.0f, 0.0f), 25.0f, 22.0f, 19.0f);
        this.theWorld.addLight(new SimpleVector(-1000.0f, -150.0f, 1000.0f), 22.0f, 5.0f, 4.0f);
        this.theWorld.addLight(new SimpleVector(1000.0f, -150.0f, -1000.0f), 4.0f, 2.0f, 22.0f);
        this.theWorld.setFogging(1);
        this.theWorld.setFogParameters(1200.0f, 0.0f, 0.0f, 0.0f);
        Config.farPlane = 1200.0f;
        c = File.separatorChar;
        this.numbers = new Texture("textures" + c + "other" + c + "numbers.jpg");
        this.texMan.addTexture("numbers", this.numbers);
        Texture texture = new Texture("textures" + c + "rocks.jpg");
        this.texMan.addTexture("rocks", texture);
        Object3D[] object3DArray = Loader.load3DS((String)("models" + c + "terascene.3ds"), (float)400.0f);
        if (object3DArray.length > 0) {
            this.terrain = object3DArray[0];
            this.terrain.setTexture("rocks");
        }
        this.terrain.enableLazyTransformations();
        this.theWorld.addObject(this.terrain);
        this.car = new Car();
        this.car.addToWorld(this.theWorld);
        this.terrain.build();
        SimpleVector simpleVector = this.terrain.getCenter();
        simpleVector.scalarMul(-1.0f);
        this.terrain.translate(simpleVector);
        this.terrain.rotateX(-1.5707964f);
        this.terrain.translateMesh();
        this.terrain.rotateMesh();
        this.terrain.setTranslationMatrix(new Matrix());
        this.terrain.setRotationMatrix(new Matrix());
        TextureInfo textureInfo = new TextureInfo(this.texMan.getTextureID("rocks"), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.terrain.setTexture(textureInfo);
        this.terrain.createTriangleStrips(2);
        this.bulMan = new ProjectileManager(this.theWorld);
        this.plantMan = new PlantManager(this.theWorld, this.terrain, 1800.0f);
        this.skidMan = new SkidMarkManager(this.theWorld);
        OcTree ocTree = new OcTree(this.terrain, 50, 1);
        this.terrain.setOcTree(ocTree);
        ocTree.setCollisionUse(true);
        Config.collideOffset = 250.0f;
        this.terrain.setCollisionMode(1);
        this.terrain.setCollisionOptimization(true);
        this.terrain.addCollisionListener((CollisionListener)new BulletTerrainListener(this.bulMan));
        this.camera = this.theWorld.getCamera();
        this.camera.setPosition(0.0f, -2500.0f, -1500.0f);
        this.camera.lookAt(this.car.getTransformedCenter());
        Config.tuneForOutdoor();
        this.initializeFrame();
        this.gameLoop();
    }

    public void startPainting() {
    }

    public void finishedPainting() {
        ++this.fps;
        ++this.fpsRes;
        this.pps += this.theWorld.getVisibilityList().getSize();
    }

    private void initializeFrame() {
        this.setTitle("jPCT " + Config.getVersion());
        ((Component)this).setSize(this.width, this.height);
        this.setLayout(null);
        ((Component)this).setVisible(true);
        this.addWindowListener(new WindowEvents());
    }

    private void display() {
        this.blitNumber((int)this.totalFps, 5, 25);
        this.blitNumber(this.lastPps, 5, 35);
        this.plantMan.drawRadar(this.buffer, this.car);
        this.buffer.displayGLOnly();
    }

    private void blitNumber(int n, int n2, int n3) {
        if (this.numbers != null) {
            String string = Integer.toString(n);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n4 = c - 48;
                this.buffer.blit(this.numbers, n4 * 5, 0, n2, n3, 5, 9, true);
                n2 += 5;
            }
        }
    }

    private void moveCar() {
        boolean bl;
        if (this.left) {
            this.car.turnLeft();
        }
        if (this.right) {
            this.car.turnRight();
        }
        Matrix matrix = this.car.getTranslationMatrix().cloneMatrix();
        if (this.forward) {
            if (this.speed < 15.0f) {
                this.speed += 0.1f;
            }
            this.car.setSpeed(this.speed);
            this.car.moveForward();
        }
        if (this.back) {
            if (this.speed > 0.0f) {
                this.speed -= 0.3f;
            }
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
            this.car.setSpeed(this.speed);
            this.car.moveForward();
        }
        if (this.speed >= 0.0f && !this.back && !this.forward) {
            this.speed -= 0.075f;
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
            this.car.setSpeed(this.speed);
            this.car.moveForward();
        }
        if (!(bl = this.car.place(this.terrain))) {
            this.car.setTranslationMatrix(matrix);
            this.speed = 0.0f;
            this.car.setSpeed(this.speed);
        } else {
            this.skidMan.createSkidMarks(this.car);
        }
    }

    private void moveCamera() {
        SimpleVector simpleVector = this.camera.getPosition();
        SimpleVector simpleVector2 = new SimpleVector(simpleVector);
        simpleVector.scalarMul(9.0f);
        SimpleVector simpleVector3 = this.car.getTransformedCenter();
        SimpleVector simpleVector4 = new SimpleVector(simpleVector3);
        SimpleVector simpleVector5 = this.car.getZAxis();
        SimpleVector simpleVector6 = new SimpleVector(0.0f, -100.0f, 0.0f);
        simpleVector5.scalarMul(-250.0f);
        simpleVector4.add(simpleVector5);
        simpleVector4.add(simpleVector6);
        simpleVector4.add(simpleVector);
        simpleVector4.scalarMul(0.1f);
        SimpleVector simpleVector7 = simpleVector4.calcSub(simpleVector2);
        float f = simpleVector7.length();
        if (f != 0.0f) {
            this.theWorld.checkCameraCollisionEllipsoid(simpleVector7.normalize(), new SimpleVector(20.0f, 20.0f, 20.0f), f, 3);
        }
        this.camera.lookAt(this.car.getTransformedCenter());
    }

    private void processProjectiles() {
        if (this.fire || this.fireCount != 3) {
            --this.fireCount;
            if (this.fireCount == 0) {
                this.bulMan.createBullet(this.car);
                this.fireCount = 3;
            }
        }
        this.bulMan.moveBullets();
    }

    private void showResults() {
        if (!this.finished) {
            this.time = System.currentTimeMillis() - this.time;
            final JDialog jDialog = new JDialog();
            jDialog.setTitle("Results (Multi)");
            jDialog.getContentPane().setLayout(new FlowLayout(1));
            String string = "Frames rendered: " + this.fpsRes;
            int n = (int)((float)this.fpsRes / (float)this.time * 100000.0f);
            int n2 = n / 100;
            int n3 = n - n2 * 100;
            String string2 = "Frames per second: " + n2 + "." + n3;
            JLabel jLabel = new JLabel(string);
            jDialog.getContentPane().add(jLabel);
            jDialog.getContentPane().add(new JLabel(string2));
            JButton jButton = new JButton("Quit!");
            JButton jButton2 = new JButton("Restart");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AWTCarTest.this.exit = true;
                    jDialog.hide();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.hide();
                    AWTCarTest.this.reset = true;
                    AWTCarTest.this.finished = false;
                }
            });
            jDialog.getContentPane().add(jButton);
            jDialog.getContentPane().add(jButton2);
            ((Component)jDialog).setSize(200, 110);
            jDialog.setResizable(false);
            jDialog.show();
            this.finished = true;
        }
    }

    private void gameLoop() {
        World.setDefaultThread((Thread)Thread.currentThread());
        this.buffer = new FrameBuffer(this.width, this.height, 0);
        this.buffer.disableRenderer(1);
        Canvas canvas = this.buffer.enableGLCanvasRenderer(1);
        this.add(canvas);
        this.buffer.setBoundingBoxMode(false);
        this.buffer.setPaintListener((IPaintListener)this);
        this.keyMapper = new KeyMapper((Component)canvas);
        Config.glVertexArrays = true;
        Timer timer = new Timer(25);
        timer.start();
        Timer timer2 = new Timer(1000);
        timer2.start();
        this.time = System.currentTimeMillis();
        while (!this.exit) {
            if (!this.isIdle) {
                if (this.reset) {
                    this.car.reset();
                    this.speed = 0.0f;
                    this.theWorld.setCameraTo(new Camera());
                    this.camera = this.theWorld.getCamera();
                    this.camera.setPosition(0.0f, -2500.0f, -1500.0f);
                    this.camera.lookAt(this.car.getTransformedCenter());
                    this.fps = 0;
                    this.lastFps = 0;
                    this.totalFps = 0L;
                    this.fpsRes = 0L;
                    this.pps = 0;
                    this.itty = ((AbstractList)this.keyStates).iterator();
                    this.skidMan.hideAll();
                    this.bulMan.hideDecals();
                    this.time = System.currentTimeMillis();
                    timer.reset();
                    timer2.reset();
                    this.reset = false;
                }
                long l = timer.getElapsedTicks();
                int n = 0;
                while ((long)n < l) {
                    if (this.recordBenchmark) {
                        this.keyStates.add(new KeyStamp(this.left, this.right, this.forward, this.back, this.fire));
                    }
                    if (this.playBenchmark) {
                        if (this.itty.hasNext()) {
                            KeyStamp keyStamp = (KeyStamp)this.itty.next();
                            this.left = keyStamp.getLeft();
                            this.right = keyStamp.getRight();
                            this.forward = keyStamp.getForward();
                            this.back = keyStamp.getBack();
                            this.fire = keyStamp.getFire();
                        } else {
                            this.showResults();
                        }
                    }
                    this.moveCar();
                    this.processProjectiles();
                    this.moveCamera();
                    ++n;
                }
                this.poll();
                this.buffer.clear();
                this.theWorld.renderScene(this.buffer);
                if (!this.wireframe) {
                    this.theWorld.draw(this.buffer);
                } else {
                    this.theWorld.drawWireframe(this.buffer, Color.white);
                }
                this.buffer.update();
                this.display();
                canvas.repaint();
                if (timer2.getElapsedTicks() > 0L) {
                    this.totalFps = this.fps - this.lastFps;
                    this.lastFps = this.fps;
                    this.lastPps = this.pps;
                    this.pps = 0;
                }
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buffer.disableRenderer(2);
        System.exit(0);
    }

    private void poll() {
        if (!this.playBenchmark) {
            KeyState keyState = null;
            do {
                if ((keyState = this.keyMapper.poll()) == KeyState.NONE) continue;
                this.keyAffected(keyState);
            } while (keyState != KeyState.NONE);
        }
    }

    private void keyAffected(KeyState keyState) {
        int n = keyState.getKeyCode();
        boolean bl = keyState.getState();
        switch (n) {
            case 66: {
                if (!this.recordBenchmark) break;
                System.out.println("Writing keystates!");
                FileOutputStream fileOutputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream("keys.ser");
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(this.keyStates);
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
            }
            case 27: {
                this.exit = bl;
                break;
            }
            case 37: {
                this.left = bl;
                break;
            }
            case 39: {
                this.right = bl;
                break;
            }
            case 38: {
                this.forward = bl;
                break;
            }
            case 32: {
                this.fire = bl;
                break;
            }
            case 40: {
                this.back = bl;
                break;
            }
            case 87: {
                if (!bl) break;
                this.wireframe = !this.wireframe;
            }
        }
    }

    private class Timer {
        private long ticks = 0L;
        private long granularity = 0L;

        public Timer(int n) {
            this.granularity = n;
        }

        public void start() {
            this.ticks = System.currentTimeMillis();
        }

        public void reset() {
            this.start();
        }

        public long getElapsedTicks() {
            long l = System.currentTimeMillis();
            long l2 = l - this.ticks;
            if (l2 >= this.granularity) {
                this.ticks = l - l2 % this.granularity;
                return l2 / this.granularity;
            }
            return 0L;
        }
    }

    private class WindowEvents
    extends WindowAdapter {
        private WindowEvents() {
        }

        public void windowIconified(WindowEvent windowEvent) {
            AWTCarTest.this.isIdle = true;
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            AWTCarTest.this.isIdle = false;
        }

        public void windowClosing(WindowEvent windowEvent) {
            AWTCarTest.this.dispose();
            AWTCarTest.this.exit = true;
        }
    }
}

