/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GenericVertexController;
import com.threed.jpct.Interact2D;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.PolygonManager;
import com.threed.jpct.Primitives;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureInfo;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import java.awt.Color;
import java.io.Serializable;

public class Overlay
implements Serializable {
    private static final long serialVersionUID = 2L;
    private World world;
    private Object3D plane;
    private MyController adjuster = null;
    private int upperLeftX;
    private int upperLeftY;
    private int lowerRightX;
    private int lowerRightY;
    private int upperLeftU;
    private int upperLeftV;
    private int lowerRightU;
    private int lowerRightV;
    private float depth = Config.nearPlane + 1.0f;
    private boolean disposed = false;
    private boolean uvChange = false;
    private float rotation = 0.0f;
    private boolean rotMode = false;

    public Overlay(World world, FrameBuffer frameBuffer, String string) {
        this(world, 0, 0, frameBuffer.getOutputWidth(), frameBuffer.getOutputHeight(), string);
    }

    public Overlay(World world, int n, int n2, int n3, int n4, String string) {
        this.world = world;
        this.upperLeftX = n;
        this.upperLeftY = n2;
        this.lowerRightX = n3;
        this.lowerRightY = n4;
        this.plane = Primitives.getPlane(1, 1.0f);
        if (string != null) {
            this.plane.setTexture(string);
        }
        this.plane.build();
        this.plane.setAdditionalColor(Color.white);
        this.plane.setLighting(1);
        this.plane.setUserObject(this);
        this.plane.setSelectable(false);
        world.addObject(this.plane);
        this.plane.build();
        this.adjuster = new MyController();
        this.plane.getMesh().setVertexController(this.adjuster, false);
    }

    public void setDepth(float f) {
        if (f < Config.nearPlane) {
            f = Config.nearPlane + 0.1f;
        }
        this.depth = f;
    }

    public void setSelectable(boolean bl) {
        this.plane.setSelectable(bl);
    }

    public void setTransparency(int n) {
        this.plane.setTransparency(n);
    }

    public void setColor(Color color) {
        this.plane.setAdditionalColor(color);
    }

    public void setTexture(String string) {
        this.plane.setTexture(string);
        this.plane.recreateTextureCoords();
    }

    public void setTexture(TextureInfo textureInfo) {
        this.plane.setTexture(textureInfo);
        this.plane.recreateTextureCoords();
    }

    public void setVisibility(boolean bl) {
        this.plane.setVisibility(bl);
    }

    public void setTransparencyMode(int n) {
        this.plane.setTransparencyMode(n);
    }

    public void setNewCoordinates(int n, int n2, int n3, int n4) {
        this.upperLeftX = n;
        this.upperLeftY = n2;
        this.lowerRightX = n3;
        this.lowerRightY = n4;
    }

    public void setSourceCoordinates(int n, int n2, int n3, int n4) {
        this.upperLeftU = n;
        this.upperLeftV = n2;
        this.lowerRightU = n3;
        this.lowerRightV = n4;
        this.uvChange = true;
    }

    public void setRotation(float f) {
        this.rotation = f;
        if (f != 0.0f) {
            this.rotMode = true;
        }
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.world.removeObject(this.plane);
            this.plane.setUserObject(null);
            this.world = null;
            this.plane = null;
            this.adjuster = null;
        }
    }

    public void unlink() {
        this.plane.setUserObject(null);
    }

    public void update(FrameBuffer frameBuffer) {
        if (this.plane.getVisibility() && !this.disposed) {
            Object object;
            Serializable serializable;
            Object object2;
            if (this.uvChange) {
                object2 = this.plane.getPolygonManager();
                int n = ((PolygonManager)object2).getPolygonTexture(0);
                serializable = TextureManager.getInstance().getTextureByID(n);
                float f = (float)this.upperLeftU / (float)((Texture)serializable).getWidth();
                float f2 = (float)this.upperLeftV / (float)((Texture)serializable).getHeight();
                float f3 = (float)this.lowerRightU / (float)((Texture)serializable).getWidth();
                float f4 = (float)this.lowerRightV / (float)((Texture)serializable).getHeight();
                object = new TextureInfo(n, f, f2, f, f4, f3, f2);
                ((PolygonManager)object2).setPolygonTexture(0, (TextureInfo)object);
                object = new TextureInfo(n, f, f4, f3, f4, f3, f2);
                ((PolygonManager)object2).setPolygonTexture(1, (TextureInfo)object);
                this.plane.recreateTextureCoords();
            }
            object2 = Interact2D.reproject2D3D(this.world.getCamera(), frameBuffer, this.upperLeftX, this.upperLeftY, this.depth);
            SimpleVector simpleVector = Interact2D.reproject2D3D(this.world.getCamera(), frameBuffer, this.upperLeftX, this.lowerRightY, this.depth);
            serializable = Interact2D.reproject2D3D(this.world.getCamera(), frameBuffer, this.lowerRightX, this.lowerRightY, this.depth);
            SimpleVector simpleVector2 = Interact2D.reproject2D3D(this.world.getCamera(), frameBuffer, this.lowerRightX, this.upperLeftY, this.depth);
            Matrix matrix = this.world.getCamera().getBack().cloneMatrix();
            SimpleVector simpleVector3 = this.world.getCamera().getPosition();
            simpleVector3.matMul(matrix);
            ((SimpleVector)object2).add(simpleVector3);
            simpleVector.add(simpleVector3);
            ((SimpleVector)serializable).add(simpleVector3);
            simpleVector2.add(simpleVector3);
            Matrix matrix2 = matrix.invert3x3();
            ((SimpleVector)object2).matMul(matrix2);
            simpleVector.matMul(matrix2);
            ((SimpleVector)serializable).matMul(matrix2);
            simpleVector2.matMul(matrix2);
            this.adjuster.setNewBounds((SimpleVector)object2, simpleVector, simpleVector2, (SimpleVector)serializable);
            this.plane.getMesh().applyVertexController();
            if (this.rotMode) {
                this.plane.getRotationMatrix().setIdentity();
                object = new SimpleVector();
                ((SimpleVector)object).add((SimpleVector)object2);
                ((SimpleVector)object).add(simpleVector);
                ((SimpleVector)object).add(simpleVector2);
                ((SimpleVector)object).add((SimpleVector)serializable);
                ((SimpleVector)object).scalarMul(0.25f);
                this.plane.setRotationPivot((SimpleVector)object);
                this.plane.rotateAxis(matrix2.getZAxis(), this.rotation);
            }
        }
    }

    protected void finalize() {
        this.dispose();
    }

    private static class MyController
    extends GenericVertexController {
        private static final long serialVersionUID = 1L;
        private SimpleVector[] poss = new SimpleVector[4];

        private MyController() {
        }

        public void apply() {
            SimpleVector[] simpleVectorArray = this.getDestinationMesh();
            for (int i = 0; i < 4; ++i) {
                simpleVectorArray[i] = this.poss[i];
            }
        }

        public void setNewBounds(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3, SimpleVector simpleVector4) {
            this.poss[0] = simpleVector;
            this.poss[1] = simpleVector2;
            this.poss[2] = simpleVector3;
            this.poss[3] = simpleVector4;
        }
    }
}

