/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.procs;

import com.threed.jpct.FrameBuffer;
import com.threed.jpct.IPostProcessor;
import com.threed.jpct.Logger;
import com.threed.jpct.procs.ProcsHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class BloomGLProcessor
implements IPostProcessor {
    private int screenTexture = 0;
    private int blurTexture = 0;
    private int w = 0;
    private int h = 0;
    private int wq = 0;
    private int hq = 0;
    private int steps = 4;
    private int blurSteps = 4;
    private int strength = 2;
    private int quality = 1;
    private boolean hasGL = false;
    private boolean disposed = false;
    private boolean isInitialized = false;
    private boolean message = false;
    private boolean comb = true;

    public BloomGLProcessor() {
    }

    public BloomGLProcessor(int n, int n2, int n3, int n4) {
        this.steps = Math.max(0, n);
        this.blurSteps = Math.max(0, n2);
        this.strength = Math.max(0, n3);
        this.quality = Math.max(0, n4);
    }

    public void init(FrameBuffer frameBuffer) {
        if (!this.isInitialized) {
            try {
                boolean bl = this.hasGL = frameBuffer.usesRenderer(2) && (this.supports("EXT_texture_rectangle") || this.supports("NV_texture_rectangle"));
                if (this.hasGL) {
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
                    GL11.glGetInteger((int)34040, (IntBuffer)intBuffer);
                    int n = intBuffer.get(0);
                    intBuffer = null;
                    this.disposed = false;
                    this.w = frameBuffer.getOutputWidth();
                    this.h = frameBuffer.getOutputHeight();
                    if (this.w <= n && this.h <= n) {
                        this.wq = this.w >> this.quality;
                        this.hq = this.h >> this.quality;
                        int n2 = this.w * this.h;
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 << 2);
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        IntBuffer intBuffer2 = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
                        GL11.glGenTextures((IntBuffer)intBuffer2);
                        this.screenTexture = intBuffer2.get(0);
                        GL11.glBindTexture((int)34037, (int)this.screenTexture);
                        GL11.glTexParameteri((int)34037, (int)10241, (int)9729);
                        GL11.glTexParameteri((int)34037, (int)10240, (int)9729);
                        GL11.glTexImage2D((int)34037, (int)0, (int)32849, (int)this.w, (int)this.h, (int)0, (int)6407, (int)5121, (ByteBuffer)byteBuffer);
                        GL11.glGenTextures((IntBuffer)intBuffer2);
                        this.blurTexture = intBuffer2.get(0);
                        GL11.glBindTexture((int)34037, (int)this.blurTexture);
                        GL11.glTexParameteri((int)34037, (int)10241, (int)9729);
                        GL11.glTexParameteri((int)34037, (int)10240, (int)9729);
                        GL11.glTexImage2D((int)34037, (int)0, (int)32849, (int)this.wq, (int)this.hq, (int)0, (int)6407, (int)5121, (ByteBuffer)byteBuffer);
                        Logger.log("Post processing textures created!", 2);
                        this.isInitialized = true;
                    } else {
                        Logger.log("Framebuffer dimensions exceed maximum resolution for arbitrary textures (" + n + ")", 1);
                    }
                } else if (!this.message) {
                    if (frameBuffer.usesRenderer(2)) {
                        Logger.log("This graphics card doesn't support arbitrary textures!", 1);
                    } else {
                        Logger.log("There's no bloom processor for the software renderer available!", 1);
                    }
                    this.message = true;
                }
            }
            catch (Exception exception) {
                Logger.log("Unable to initialize post processing textures due to: " + exception.getMessage(), 1);
                exception.printStackTrace();
            }
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setCombining(boolean bl) {
        this.comb = bl;
    }

    public void process() {
        if (this.hasGL) {
            int n;
            GL11.glEnable((int)34037);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            GL11.glBindTexture((int)34037, (int)this.screenTexture);
            GL11.glCopyTexImage2D((int)34037, (int)0, (int)6407, (int)0, (int)0, (int)this.w, (int)this.h, (int)0);
            ProcsHelper.toOrtho();
            GL11.glViewport((int)0, (int)0, (int)this.wq, (int)this.hq);
            GL11.glBindTexture((int)34037, (int)this.screenTexture);
            GL11.glBlendFunc((int)774, (int)0);
            GL11.glDisable((int)3042);
            GL11.glBegin((int)7);
            this.drawQuad(this.w, this.h, 0, 0);
            GL11.glEnd();
            GL11.glEnable((int)3042);
            GL11.glBegin((int)7);
            for (int i = 0; i < this.steps; ++i) {
                this.drawQuad(this.w, this.h, 0, 0);
            }
            GL11.glEnd();
            GL11.glBindTexture((int)34037, (int)this.blurTexture);
            GL11.glCopyTexImage2D((int)34037, (int)0, (int)6407, (int)0, (int)0, (int)this.wq, (int)this.hq, (int)0);
            float f = 1.0f / ((float)this.blurSteps * 2.0f + 1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
            GL11.glBlendFunc((int)770, (int)0);
            GL11.glBegin((int)7);
            this.drawQuad(this.wq, this.hq, 0, 0);
            GL11.glEnd();
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glBegin((int)7);
            for (n = 0; n < this.blurSteps; ++n) {
                this.drawQuad(this.wq, this.hq, -n, 0);
                this.drawQuad(this.wq, this.hq, n, 0);
            }
            GL11.glEnd();
            GL11.glCopyTexImage2D((int)34037, (int)0, (int)6407, (int)0, (int)0, (int)this.wq, (int)this.hq, (int)0);
            GL11.glBlendFunc((int)770, (int)0);
            GL11.glBegin((int)7);
            this.drawQuad(this.wq, this.hq, 0, 0);
            GL11.glEnd();
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glBegin((int)7);
            for (n = 0; n < this.blurSteps; ++n) {
                this.drawQuad(this.wq, this.hq, 0, -n);
                this.drawQuad(this.wq, this.hq, 0, n);
            }
            GL11.glEnd();
            GL11.glCopyTexImage2D((int)34037, (int)0, (int)6407, (int)0, (int)0, (int)this.wq, (int)this.hq, (int)0);
            GL11.glViewport((int)0, (int)0, (int)this.w, (int)this.h);
            GL11.glDisable((int)3042);
            GL11.glBegin((int)7);
            this.drawQuad(this.wq, this.hq, 0, 0);
            GL11.glEnd();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glBegin((int)7);
            for (n = 0; n < this.strength; ++n) {
                this.drawQuad(this.wq, this.hq, 0, 0);
            }
            GL11.glEnd();
            if (this.comb) {
                GL11.glBindTexture((int)34037, (int)this.screenTexture);
                GL11.glBegin((int)7);
                this.drawQuad(this.w, this.h, 0, 0);
                GL11.glEnd();
            }
            ProcsHelper.restoreProjection();
            GL11.glDisable((int)34037);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
        }
    }

    private boolean supports(String string) {
        String string2 = GL11.glGetString((int)7939);
        return string2.toLowerCase().indexOf(string.toLowerCase()) != -1;
    }

    private void drawQuad(int n, int n2, int n3, int n4) {
        GL11.glTexCoord2f((float)n3, (float)n4);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
        GL11.glTexCoord2f((float)n3, (float)(n2 + n4));
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glTexCoord2f((float)(n + n3), (float)(n2 + n4));
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
        GL11.glTexCoord2f((float)(n + n3), (float)n4);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
    }

    public void dispose() {
        if (!this.disposed && this.isInitialized) {
            try {
                if (Display.isCreated()) {
                    Logger.log("Unloading post processing textures!", 2);
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
                    intBuffer.put(this.screenTexture);
                    ((Buffer)intBuffer).flip();
                    GL11.glDeleteTextures((IntBuffer)intBuffer);
                    intBuffer.put(this.blurTexture);
                    ((Buffer)intBuffer).flip();
                    GL11.glDeleteTextures((IntBuffer)intBuffer);
                }
            }
            catch (Exception exception) {
                Logger.log("Unable to unload post processing textures - already done?", 1);
            }
            this.isInitialized = false;
            this.message = false;
            this.disposed = true;
        }
    }

    protected void finalize() {
        if (this.hasGL) {
            this.dispose();
        }
    }
}

