/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.AWTBufferList;
import com.threed.jpct.Config;
import com.threed.jpct.ICompiledInstance;
import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.TextureManager;
import java.io.Serializable;
import java.util.Vector;

public final class VisList
implements Serializable {
    private static final long serialVersionUID = 1L;
    int anzpoly;
    int size;
    Object3D[] vobj;
    Object3D[] vorg;
    int[] vnum;
    int[] vnumOrg;
    int[] portalNum;
    int[] mode;
    float[] zValue;
    int[] stageCnt;
    long lastCycle = -1L;
    private Object3D[] vobj2;
    private Object3D[] vorg2;
    private int[] vnum2;
    private int[] vnumOrg2;
    private int[] portalNum2;
    private int[] mode2;
    private float[] zValue2;
    private int[] stageCnt2;
    boolean splitted = false;
    private int pivotindex;
    private int fillBuffer = -1;
    private boolean isExtracted = false;
    private boolean hasBeenSwitched = false;
    private transient AWTBufferList[] buffer = null;
    private int msgCnt = 0;
    private int maxStages = 0;
    private Vector toFill = new Vector();

    VisList(int n) {
        this.vobj = new Object3D[n + 1];
        this.vorg = new Object3D[n + 1];
        this.vnum = new int[n + 1];
        this.vnumOrg = new int[n + 1];
        this.portalNum = new int[n + 1];
        this.zValue = new float[n + 1];
        this.mode = new int[n + 1];
        this.stageCnt = new int[n + 1];
        this.size = n;
        this.anzpoly = -1;
    }

    public synchronized void addToFill(Object3D object3D) {
        if (!this.toFill.contains(object3D)) {
            this.toFill.addElement(object3D);
        }
    }

    public int getSize() {
        return this.anzpoly + 1;
    }

    public int getMaxSize() {
        return this.size;
    }

    public void getData(int n, int[] nArray) {
        if (nArray.length == 2) {
            if (n >= 0 && n < this.anzpoly + 1) {
                nArray[1] = this.vnumOrg[n];
                nArray[0] = this.vorg[n].number - 2;
            } else {
                nArray[0] = -1;
                nArray[1] = -1;
            }
        } else {
            Logger.log("Please use an int[2]-array!", 0);
        }
    }

    void clearList() {
        this.anzpoly = -1;
        this.maxStages = 0;
        this.splitted = false;
    }

    void switchBuffers() {
        if (!this.hasBeenSwitched) {
            this.fillBuffer ^= 1;
            this.buffer[this.fillBuffer].clear();
            this.hasBeenSwitched = true;
        }
        this.isExtracted = false;
    }

    synchronized void fillInstances() {
        for (int i = 0; i < this.toFill.size(); ++i) {
            Object3D object3D = (Object3D)this.toFill.elementAt(i);
            if (!object3D.modified) continue;
            for (int j = 0; j < object3D.compiled.size(); ++j) {
                ICompiledInstance iCompiledInstance = (ICompiledInstance)object3D.compiled.elementAt(j);
                iCompiledInstance.fill();
            }
            object3D.modified = false;
        }
        this.toFill.clear();
    }

    AWTBufferList getFrontBuffer() {
        this.checkBuffer();
        return this.buffer[this.fillBuffer ^ 1];
    }

    AWTBufferList getBackBuffer() {
        this.checkBuffer();
        return this.buffer[this.fillBuffer];
    }

    void extract() {
        this.hasBeenSwitched = false;
        if (!this.isExtracted) {
            this.checkBuffer();
            this.buffer[this.fillBuffer].fill(this);
            this.isExtracted = true;
        }
    }

    private void checkBuffer() {
        if (this.buffer == null) {
            this.buffer = new AWTBufferList[2];
            this.buffer[0] = new AWTBufferList(this.size + 1);
            this.buffer[1] = new AWTBufferList(this.size + 1);
            this.fillBuffer = 0;
        }
    }

    void addToList(Object3D object3D, Object3D object3D2, int n, int n2, float f, int n3, boolean bl) {
        this.addToList(object3D, object3D2, n, n2, f, n3, 0, bl);
    }

    synchronized void addToList(Object3D object3D, Object3D object3D2, int n, int n2, float f, int n3, int n4, boolean bl) {
        if (this.anzpoly < this.size) {
            ++this.anzpoly;
            if (n4 > this.maxStages) {
                this.maxStages = n4;
            }
            this.stageCnt[this.anzpoly] = n4;
            this.vorg[this.anzpoly] = object3D2;
            this.vnum[this.anzpoly] = n;
            this.vnumOrg[this.anzpoly] = n2;
            this.zValue[this.anzpoly] = object3D2.isTrans && !object3D2.isBumpmapped ? 1000000.0f - f : (f += object3D2.sortOffset);
            this.portalNum[this.anzpoly] = n3;
            if (bl) {
                this.vobj[this.anzpoly] = object3D;
                int n5 = 0;
                if (object3D2.isEnvmapped) {
                    n5 = 1;
                }
                if (object3D2.isTrans) {
                    n5 |= 2;
                }
                if (object3D2.isBlended) {
                    n5 |= 4;
                }
                if (object3D2.isBumpmapped) {
                    n5 |= 8;
                }
                this.mode[this.anzpoly] = n5;
            }
        } else {
            if (this.msgCnt == 0) {
                Logger.log("You've exceeded the configured triangle limit for the visibility list. Consider adjusting Config.maxPolysVisible!", 1);
            }
            ++this.msgCnt;
        }
    }

    void switchLists() {
        if (this.splitted) {
            Object3D[] object3DArray = this.vobj2;
            this.vobj2 = this.vobj;
            this.vobj = object3DArray;
            object3DArray = this.vorg2;
            this.vorg2 = this.vorg;
            this.vorg = object3DArray;
            int[] nArray = this.vnum2;
            this.vnum2 = this.vnum;
            this.vnum = nArray;
            nArray = this.vnumOrg2;
            this.vnumOrg2 = this.vnumOrg;
            this.vnumOrg = nArray;
            nArray = this.portalNum2;
            this.portalNum2 = this.portalNum;
            this.portalNum = nArray;
            nArray = this.mode2;
            this.mode2 = this.mode;
            this.mode = nArray;
            nArray = this.stageCnt2;
            this.stageCnt2 = this.stageCnt;
            this.stageCnt = nArray;
            float[] fArray = this.zValue2;
            this.zValue2 = this.zValue;
            this.zValue = fArray;
        }
    }

    void splitForMultiPass() {
        if (this.maxStages + 1 > Config.glStageCount) {
            TextureManager textureManager = TextureManager.getInstance();
            if (this.vobj2 == null) {
                this.vobj2 = new Object3D[this.size + 1];
                this.vorg2 = new Object3D[this.size + 1];
                this.vnum2 = new int[this.size + 1];
                this.vnumOrg2 = new int[this.size + 1];
                this.portalNum2 = new int[this.size + 1];
                this.zValue2 = new float[this.size + 1];
                this.mode2 = new int[this.size + 1];
                this.stageCnt2 = new int[this.size + 1];
            }
            int n = this.anzpoly + 1;
            int n2 = 0;
            this.splitted = false;
            for (int i = 0; i < n; ++i) {
                Object3D object3D = this.vobj[i];
                Object3D object3D2 = this.vorg[i];
                int n3 = this.vnum[i];
                int n4 = this.vnumOrg[i];
                int n5 = this.portalNum[i];
                float f = this.zValue[i];
                int n6 = this.mode[i];
                this.vobj2[n2] = object3D;
                this.vorg2[n2] = object3D2;
                this.vnum2[n2] = n3;
                this.vnumOrg2[n2] = n4;
                this.portalNum2[n2] = n5;
                this.zValue2[n2] = f;
                this.mode2[n2] = n6;
                if (this.stageCnt[i] >= Config.glStageCount && object3D2.compiled == null) {
                    this.splitted = true;
                    this.stageCnt2[n2] = -1;
                    int n7 = this.stageCnt[i];
                    ++n2;
                    boolean bl = (this.mode[i] & 2) == 2;
                    boolean bl2 = Config.glMultiPassSorting && !bl;
                    int[][] nArray = object3D2.multiTex;
                    for (int j = 0; j < n7; ++j) {
                        if (!textureManager.textures[nArray[j][n4]].enabled) continue;
                        this.vorg2[n2] = object3D2;
                        this.vnum2[n2] = n3;
                        this.vnumOrg2[n2] = n4;
                        this.portalNum2[n2] = n5;
                        if (bl2) {
                            this.zValue2[n2] = 99999.0f - f + (float)(j << 1) + 100000.0f;
                        } else {
                            this.zValue2[n2] = f;
                            if (bl) {
                                int n8 = n2;
                                this.zValue2[n8] = this.zValue2[n8] + (float)(j + 1);
                            }
                        }
                        this.stageCnt2[n2] = j + 1;
                        if (++n2 < this.size) continue;
                        if (this.msgCnt == 0) {
                            Logger.log("You've exceeded the configured triangle limit for the visibility list caused by using multi pass rendering. Consider adjusting Config.maxPolysVisible!", 1);
                        }
                        ++this.msgCnt;
                        break;
                    }
                    int n9 = n2 - 1;
                    this.stageCnt2[n9] = this.stageCnt2[n9] | 0x10000;
                } else {
                    this.stageCnt2[n2] = 0;
                    ++n2;
                }
                if (n2 < this.size) continue;
                if (this.msgCnt == 0) {
                    Logger.log("You've exceeded the configured triangle limit for the visibility list caused by using multi pass rendering. Consider adjusting Config.maxPolysVisible!", 1);
                }
                ++this.msgCnt;
                break;
            }
            this.anzpoly = n2 - 1;
            this.switchLists();
        }
    }

    void sort(int n, int n2, boolean bl) {
        this.qsort(n, n2, bl);
    }

    private void qsort(int n, int n2, boolean bl) {
        this.findpivot(n, n2);
        if (this.pivotindex != -1) {
            int n3 = this.partition(n, n2, this.zValue[this.pivotindex], bl);
            this.qsort(n, n3 - 1, bl);
            this.qsort(n3, n2, bl);
        }
    }

    private int partition(int n, int n2, float f, boolean bl) {
        while (n <= n2) {
            if (this.zValue[n] < f) {
                ++n;
                continue;
            }
            if (this.zValue[n2] >= f) {
                --n2;
                continue;
            }
            float f2 = this.zValue[n2];
            this.zValue[n2] = this.zValue[n];
            this.zValue[n] = f2;
            Object3D object3D = this.vorg[n2];
            this.vorg[n2] = this.vorg[n];
            this.vorg[n] = object3D;
            int n3 = this.vnum[n2];
            this.vnum[n2] = this.vnum[n];
            this.vnum[n] = n3;
            n3 = this.vnumOrg[n2];
            this.vnumOrg[n2] = this.vnumOrg[n];
            this.vnumOrg[n] = n3;
            n3 = this.portalNum[n2];
            this.portalNum[n2] = this.portalNum[n];
            this.portalNum[n] = n3;
            if (bl) {
                object3D = this.vobj[n2];
                this.vobj[n2] = this.vobj[n];
                this.vobj[n] = object3D;
                n3 = this.mode[n2];
                this.mode[n2] = this.mode[n];
                this.mode[n] = n3;
            }
            n3 = this.stageCnt[n2];
            this.stageCnt[n2] = this.stageCnt[n];
            this.stageCnt[n] = n3;
            ++n;
            --n2;
        }
        return n;
    }

    private void findpivot(int n, int n2) {
        this.pivotindex = -1;
        int n3 = n;
        float f = this.zValue[n];
        while (this.pivotindex == -1 && n3 <= n2) {
            if (this.zValue[n3] > f) {
                this.pivotindex = n3;
                continue;
            }
            if (this.zValue[n3] < f) {
                this.pivotindex = n;
            }
            ++n3;
        }
    }
}

