/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.SimpleVector;

public class Plane {
    private float equation3 = 0.0f;
    SimpleVector normal = new SimpleVector();

    public Plane() {
    }

    public Plane(SimpleVector simpleVector, SimpleVector simpleVector2) {
        this.setTo(simpleVector, simpleVector2);
    }

    float[] getPlaneEquation() {
        float[] fArray = new float[]{this.normal.x, -this.normal.y, -this.normal.z, this.equation3};
        return fArray;
    }

    public void setTo(SimpleVector simpleVector, SimpleVector simpleVector2) {
        this.normal.set(simpleVector2);
        this.equation3 = -(simpleVector2.x * simpleVector.x + simpleVector2.y * simpleVector.y + simpleVector2.z * simpleVector.z);
    }

    public Plane(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3) {
        this.setTo(simpleVector, simpleVector2, simpleVector3);
    }

    public void setTo(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3) {
        float f = simpleVector2.y - simpleVector.y;
        float f2 = simpleVector3.z - simpleVector.z;
        float f3 = simpleVector2.z - simpleVector.z;
        float f4 = simpleVector3.y - simpleVector.y;
        double d = f * f2 - f3 * f4;
        float f5 = simpleVector3.x - simpleVector.x;
        float f6 = simpleVector2.x - simpleVector.x;
        double d2 = f3 * f5 - f6 * f2;
        double d3 = f6 * f4 - f * f5;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 != 0.0) {
            double d5 = 1.0 / d4;
            this.normal.set((float)(d * d5), (float)(d2 * d5), (float)(d3 * d5));
        } else {
            this.normal.set(0.0f, 0.0f, 0.0f);
        }
        this.equation3 = -(this.normal.x * simpleVector.x + this.normal.y * simpleVector.y + this.normal.z * simpleVector.z);
    }

    public boolean isFrontFacingTo(SimpleVector simpleVector) {
        float f = this.normal.x * simpleVector.x + this.normal.y * simpleVector.y + this.normal.z * simpleVector.z;
        return f <= 0.0f;
    }

    public float distanceTo(SimpleVector simpleVector) {
        return this.normal.x * simpleVector.x + this.normal.y * simpleVector.y + this.normal.z * simpleVector.z + this.equation3;
    }
}

