/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.IRenderHook;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.util.ShadowHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;

public class GLSLShader
implements IRenderHook {
    private String fragSource = null;
    private String vertexSource = null;
    private int prg = 0;
    private int fragShade = 0;
    private int vertShade = 0;
    private boolean init = false;
    private boolean failure = false;
    private boolean excludeShadowProcess = true;
    private ShadowHelper helper = null;
    private boolean newUniforms = false;
    private Map uniforms = new HashMap();
    private List toRemove = null;
    private int minShaderModel = -1;
    private boolean delayedDisabling = true;
    private boolean needsTangents = false;
    private int tangentHandle = -1;
    private static int lastShaderId = 0;

    public GLSLShader(String string, String string2) {
        this.fragSource = string2;
        this.vertexSource = string;
        this.needsTangents = this.vertexSource.indexOf("attribute vec4 tangent") != -1;
    }

    public void setMinShaderModel(int n) {
        this.minShaderModel = n;
    }

    public void setCurrentObject3D(Object3D object3D) {
    }

    public synchronized void beforeRendering(int n) {
        this.init();
        if (this.helper != null && this.excludeShadowProcess && this.helper.isRenderingShadowMap()) {
            return;
        }
        if (!this.failure) {
            Object[] objectArray;
            Iterator<Object> iterator;
            if (this.newUniforms) {
                iterator = this.uniforms.keySet().iterator();
                while (iterator.hasNext()) {
                    objectArray = (Object[])iterator.next();
                    Object[] objectArray2 = (Object[])this.uniforms.get(objectArray);
                    if (objectArray2[1] != null) continue;
                    int n2 = this.getLocation((String)objectArray);
                    objectArray2[1] = new Integer(n2);
                }
                this.newUniforms = false;
            }
            if (this.prg != lastShaderId || !this.delayedDisabling) {
                ARBShaderObjects.glUseProgramObjectARB((int)this.prg);
            }
            lastShaderId = this.prg;
            iterator = this.uniforms.values().iterator();
            while (iterator.hasNext()) {
                Object object;
                objectArray = (Object[])iterator.next();
                int n3 = (Integer)objectArray[1];
                Object object2 = objectArray[0];
                if (object2 instanceof Integer) {
                    ARBShaderObjects.glUniform1iARB((int)n3, (int)((Integer)object2));
                } else if (object2 instanceof Float) {
                    ARBShaderObjects.glUniform1fARB((int)n3, (float)((Float)object2).floatValue());
                } else if (object2 instanceof SimpleVector) {
                    object = (SimpleVector)object2;
                    ARBShaderObjects.glUniform3fARB((int)n3, (float)((SimpleVector)object).x, (float)((SimpleVector)object).y, (float)((SimpleVector)object).z);
                } else if (object2 instanceof float[]) {
                    object = (float[])object2;
                    switch (((Object)object).length) {
                        case 1: {
                            ARBShaderObjects.glUniform1fARB((int)n3, (float)object[0]);
                            break;
                        }
                        case 2: {
                            ARBShaderObjects.glUniform2fARB((int)n3, (float)object[0], (float)object[1]);
                            break;
                        }
                        case 3: {
                            ARBShaderObjects.glUniform3fARB((int)n3, (float)object[0], (float)object[1], (float)object[2]);
                            break;
                        }
                        case 4: {
                            ARBShaderObjects.glUniform4fARB((int)n3, (float)object[0], (float)object[1], (float)object[2], (float)object[3]);
                        }
                    }
                } else if (object2 instanceof FloatBuffer) {
                    object = (FloatBuffer)object2;
                    ((Buffer)object).rewind();
                    ARBShaderObjects.glUniformMatrix4ARB((int)n3, (boolean)false, (FloatBuffer)object);
                }
                if (objectArray[2] == null) continue;
                if (this.toRemove == null) {
                    this.toRemove = new ArrayList();
                }
                this.toRemove.add(objectArray[2]);
            }
            if (this.toRemove != null) {
                iterator = this.toRemove.iterator();
                while (iterator.hasNext()) {
                    this.uniforms.remove(iterator.next());
                }
                this.toRemove = null;
            }
        }
    }

    public void setDelayedDisabling(boolean bl) {
        this.delayedDisabling = bl;
    }

    public void afterRendering(int n) {
        if (!this.failure && this.init && !this.delayedDisabling) {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
        }
    }

    public void clear() {
        if (!this.failure && this.init && this.delayedDisabling) {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
            lastShaderId = 0;
        }
    }

    public void onDispose() {
        if (!this.failure && this.init) {
            ARBShaderObjects.glDeleteObjectARB((int)this.fragShade);
            ARBShaderObjects.glDeleteObjectARB((int)this.vertShade);
            ARBShaderObjects.glDeleteObjectARB((int)this.prg);
            this.init = false;
        }
    }

    public boolean repeatRendering() {
        return false;
    }

    public void setShadowHelper(ShadowHelper shadowHelper) {
        this.helper = shadowHelper;
    }

    public void excludeShadowMap(boolean bl) {
        this.excludeShadowProcess = bl;
    }

    public void setStaticUniform(String string, int n) {
        this.setStatic(string, new Integer(n));
    }

    public void setStaticUniform(String string, float f) {
        this.setStatic(string, new Float(f));
    }

    public void setStaticUniform(String string, float[] fArray) {
        this.setStatic(string, fArray);
    }

    public void setStaticUniform(String string, SimpleVector simpleVector) {
        this.setStatic(string, simpleVector);
    }

    public void setStaticUniform(String string, Matrix matrix) {
        this.setStatic(string, this.toFloatBuffer(matrix));
    }

    public void setUniform(String string, int n) {
        this.set(string, new Integer(n));
    }

    public void setUniform(String string, float f) {
        this.set(string, new Float(f));
    }

    public void setUniform(String string, SimpleVector simpleVector) {
        this.set(string, new SimpleVector(simpleVector));
    }

    public void setUniform(String string, float[] fArray) {
        this.set(string, fArray);
    }

    public void setUniform(String string, Matrix matrix) {
        this.set(string, this.toFloatBuffer(matrix));
    }

    boolean needsTangents() {
        return this.needsTangents;
    }

    private FloatBuffer toFloatBuffer(Matrix matrix) {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
        Matrix matrix2 = matrix.cloneMatrix();
        matrix2.transformToGL();
        float[] fArray = matrix2.getDump();
        floatBuffer.put(fArray);
        ((Buffer)floatBuffer).rewind();
        return floatBuffer;
    }

    private synchronized void set(String string, Object object) {
        Object[] objectArray = (Object[])this.uniforms.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
            this.newUniforms = true;
            this.uniforms.put(string, objectArray);
        }
        objectArray[0] = object;
    }

    private synchronized void setStatic(String string, Object object) {
        Object[] objectArray = (Object[])this.uniforms.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
            objectArray[2] = string;
            this.newUniforms = true;
            this.uniforms.put(string, objectArray);
            objectArray[0] = object;
        }
    }

    void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (!GLContext.getCapabilities().GL_ARB_fragment_program) {
            Logger.log("This hardware/driver doesn't support shaders(1)!", 1);
            this.failure = true;
            return;
        }
        if (this.fragSource == null && this.vertexSource == null) {
            Logger.log("No shader specified!", 1);
            this.failure = true;
            return;
        }
        int n = GLSLShader.guessShaderModel();
        if (this.minShaderModel > n && n != 9999 && this.minShaderModel != -1) {
            Logger.log("Shadermodel " + this.minShaderModel + " not supported on this platform!", 1);
            this.failure = true;
            return;
        }
        try {
            this.prg = ARBShaderObjects.glCreateProgramObjectARB();
        }
        catch (Throwable throwable) {
            Logger.log("This hardware/driver doesn't support shaders(2)!", 1);
            this.failure = true;
            return;
        }
        if (this.fragSource != null) {
            this.fragShade = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
            ARBShaderObjects.glShaderSourceARB((int)this.fragShade, (ByteBuffer)this.getSource(this.fragSource));
            ARBShaderObjects.glCompileShaderARB((int)this.fragShade);
            this.getInfoLog(this.fragShade);
            ARBShaderObjects.glAttachObjectARB((int)this.prg, (int)this.fragShade);
            this.fragSource = null;
        }
        if (this.vertexSource != null) {
            this.vertShade = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
            ARBShaderObjects.glShaderSourceARB((int)this.vertShade, (ByteBuffer)this.getSource(this.vertexSource));
            ARBShaderObjects.glCompileShaderARB((int)this.vertShade);
            this.getInfoLog(this.vertShade);
            ARBShaderObjects.glAttachObjectARB((int)this.prg, (int)this.vertShade);
            this.vertexSource = null;
        }
        ARBShaderObjects.glLinkProgramARB((int)this.prg);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        for (int i = 0; i < "tangent".length(); ++i) {
            char c = "tangent".charAt(i);
            byte by = (byte)c;
            byteBuffer.put(by);
        }
        ((Buffer)byteBuffer).rewind();
        this.tangentHandle = GL20.glGetAttribLocation((int)this.prg, (ByteBuffer)byteBuffer);
        if (this.tangentHandle != -1) {
            Logger.log("Found tangent handle at " + this.tangentHandle);
        } else {
            Logger.log("Tangent handle not found (tangents needed: " + this.needsTangents + ")!");
        }
        Logger.log("Shader compiled!", 2);
        String string = this.getLog();
        if (string != null) {
            Logger.log(string, 0);
        }
    }

    private void getInfoLog(int n) {
        IntBuffer intBuffer = this.createByteBuffer(4).asIntBuffer();
        ((Buffer)intBuffer).rewind();
        ByteBuffer byteBuffer = this.createByteBuffer(5000);
        ARBShaderObjects.glGetInfoLogARB((int)n, (IntBuffer)intBuffer, (ByteBuffer)byteBuffer);
        int n2 = intBuffer.get();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray, 0, n2);
        Logger.log(new String(byArray, 0, n2));
    }

    private ByteBuffer getSource(String string) {
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = this.createByteBuffer(byArray.length);
        byteBuffer.put(byArray);
        ((Buffer)byteBuffer).flip();
        return byteBuffer;
    }

    private int getLocation(String string) {
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = this.createByteBuffer(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ((Buffer)byteBuffer).flip();
        return ARBShaderObjects.glGetUniformLocationARB((int)this.prg, (ByteBuffer)byteBuffer);
    }

    private String getLog() {
        IntBuffer intBuffer = this.createByteBuffer(4).asIntBuffer();
        String string = null;
        ARBShaderObjects.glGetObjectParameterARB((int)this.prg, (int)35714, (IntBuffer)intBuffer);
        int n = intBuffer.get();
        if (n == 0) {
            ((Buffer)intBuffer).flip();
            ByteBuffer byteBuffer = this.createByteBuffer(5000);
            ARBShaderObjects.glGetInfoLogARB((int)this.prg, (IntBuffer)intBuffer, (ByteBuffer)byteBuffer);
            int n2 = intBuffer.get();
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray, 0, n2);
            string = new String(byArray, 0, n2);
            this.failure = true;
        }
        return string;
    }

    private ByteBuffer createByteBuffer(int n) {
        return ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
    }

    public static int guessShaderModel() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        int n = 9999;
        if (contextCapabilities.GL_NV_vertex_program) {
            n = 1;
        }
        if (contextCapabilities.GL_NV_vertex_program2) {
            n = 2;
        }
        if (contextCapabilities.GL_NV_vertex_program3) {
            n = 3;
        }
        if (contextCapabilities.GL_NV_vertex_program4) {
            n = 4;
        }
        if (contextCapabilities.GL_ATI_shader_texture_lod) {
            n = 3;
        }
        if (contextCapabilities.GL_EXT_gpu_shader4) {
            n = 4;
        }
        return n;
    }

    void clearTangents(FloatBuffer floatBuffer, int n) {
        if (this.tangentHandle != -1) {
            GL20.glDisableVertexAttribArray((int)this.tangentHandle);
        }
    }

    void setTangents(FloatBuffer floatBuffer, int n) {
        if (this.tangentHandle != -1) {
            if (n > 0) {
                GL15.glBindBuffer((int)34962, (int)n);
                GL20.glEnableVertexAttribArray((int)this.tangentHandle);
                GL20.glVertexAttribPointer((int)this.tangentHandle, (int)4, (int)5126, (boolean)false, (int)16, (long)0L);
            } else if (floatBuffer != null) {
                GL20.glEnableVertexAttribArray((int)this.tangentHandle);
                GL20.glVertexAttribPointer((int)this.tangentHandle, (int)4, (boolean)false, (int)16, (FloatBuffer)floatBuffer);
            }
        }
    }
}

