/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Logger;
import java.io.Serializable;
import java.util.Vector;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

class GLHelper
implements Serializable {
    private static final long serialVersionUID = 1L;

    GLHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void swap() {
        if (Display.isCreated()) {
            Object object = FrameBuffer.SYNCHRONIZER;
            synchronized (object) {
                if (Config.glForceFinish) {
                    GL11.glFinish();
                }
                Display.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose() {
        if (Display.isCreated()) {
            Object object = FrameBuffer.SYNCHRONIZER;
            synchronized (object) {
                try {
                    Display.destroy();
                }
                catch (Exception exception) {
                    Logger.log("Display shutdown already in progress!", 2);
                }
            }
        }
    }

    static PixelFormat getPixelFormatFromConfig() {
        if (Config.glAdditionalConfiguration != null) {
            for (int i = 0; i < Config.glAdditionalConfiguration.length; ++i) {
                if (!(Config.glAdditionalConfiguration[i] instanceof PixelFormat)) continue;
                return (PixelFormat)Config.glAdditionalConfiguration[i];
            }
        }
        return null;
    }

    static DisplayMode getDisplayModeFromConfig() {
        if (Config.glAdditionalConfiguration != null) {
            for (int i = 0; i < Config.glAdditionalConfiguration.length; ++i) {
                if (!(Config.glAdditionalConfiguration[i] instanceof DisplayMode)) continue;
                return (DisplayMode)Config.glAdditionalConfiguration[i];
            }
        }
        return null;
    }

    static DisplayMode findMode(int n, int n2, int n3, int n4) throws Exception {
        return GLHelper.findMode(n, n2, n3, n4, false);
    }

    static DisplayMode findMode(int n, int n2, int n3, int n4, boolean bl) throws Exception {
        int n5;
        int n6 = -1;
        DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
        for (n5 = 0; n5 < displayModeArray.length; ++n5) {
            if (Config.glVerbose) {
                Logger.log("mode: " + displayModeArray[n5].getWidth() + "/" + displayModeArray[n5].getHeight() + "/" + displayModeArray[n5].getBitsPerPixel() + "/" + displayModeArray[n5].getFrequency(), 2);
            }
            if (displayModeArray[n5].getWidth() != n || displayModeArray[n5].getHeight() != n2 || displayModeArray[n5].getBitsPerPixel() != n3 || Config.glRefresh != 0 && displayModeArray[n5].getFrequency() != Config.glRefresh && Config.glFullscreen) continue;
            n6 = n5;
            break;
        }
        if (n6 == -1) {
            if (!bl) {
                Logger.log("Can't find desired videomode (" + n + " x " + n2 + " x " + n3 + ") - searching for alternatives", 2);
            }
            for (n5 = 0; n5 < displayModeArray.length; ++n5) {
                if (displayModeArray[n5].getWidth() != n || displayModeArray[n5].getHeight() != n2 || displayModeArray[n5].getBitsPerPixel() < n3 || displayModeArray[n5].getFrequency() < Config.glRefresh && Config.glFullscreen) continue;
                n6 = n5;
                break;
            }
            if (n6 == -1) {
                if (!bl) {
                    Logger.log("Can't find alternative videomode (" + n + " x " + n2 + " x " + n3 + ") - trying something else", 2);
                }
                for (n5 = 0; n5 < displayModeArray.length; ++n5) {
                    if (displayModeArray[n5].getWidth() != n || displayModeArray[n5].getHeight() != n2) continue;
                    n6 = n5;
                    break;
                }
            }
            if (n6 == -1) {
                if (!bl) {
                    Logger.log("Can't find any suitable videomode!", 0);
                }
                return null;
            }
        }
        return displayModeArray[n6];
    }

    static void printDriver() {
        try {
            String string = Display.getAdapter() + "/" + Display.getVersion();
            String string2 = GLHelper.getHardware();
            if (string2 == null) {
                string2 = "unknown card";
            }
            if (string.equals("null/null")) {
                string = "unknown OpenGL driver";
            }
            if (string.indexOf("intel") != -1 || string2.indexOf("intel") != -1) {
                Config.glBatchSize = Math.min(1000, Config.glBatchSize);
            }
            Logger.log("Driver is: " + string + " on " + string2, 2);
        }
        catch (Throwable throwable) {
            Logger.log("Driver is unknown!", 2);
        }
    }

    static final String getHardware() {
        return GL11.glGetString((int)7936) + " / " + GL11.glGetString((int)7937);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean init(int n, int n2, int n3, int n4, int n5) {
        if (Config.glSkipInitialization) {
            return true;
        }
        boolean bl = true;
        int n6 = 0;
        DisplayMode displayMode = GLHelper.getDisplayModeFromConfig();
        PixelFormat pixelFormat = GLHelper.getPixelFormatFromConfig();
        try {
            if (displayMode == null && (displayMode = GLHelper.findMode(n, n2, n3, n4)) == null) {
                bl = false;
            }
            n6 = displayMode.getBitsPerPixel();
            Logger.log("Current mode:" + displayMode, 2);
            Object object = FrameBuffer.SYNCHRONIZER;
            synchronized (object) {
                Display.setFullscreen((boolean)Config.glFullscreen);
                Display.setDisplayMode((DisplayMode)displayMode);
                Display.setTitle((String)Config.glWindowName);
                Display.setVSyncEnabled((boolean)Config.glVSync);
                Vector<Throwable> vector = new Vector<Throwable>();
                if (pixelFormat == null) {
                    try {
                        Display.create((PixelFormat)new PixelFormat(n6, 0, n4, 0, n5));
                    }
                    catch (Throwable throwable) {
                        vector.addElement(throwable);
                        boolean bl2 = false;
                        if (n5 != 0) {
                            try {
                                Logger.log("Number of samples (" + n5 + ") not supported!", 1);
                                Display.create((PixelFormat)new PixelFormat(n6, 0, n4, 0, 0));
                                bl2 = true;
                            }
                            catch (Throwable throwable2) {
                                vector.addElement(throwable2);
                            }
                        }
                        if (bl2) return bl;
                        Logger.log("ZBuffer depth of " + n4 + " not supported - trying something else now...!", 1);
                        try {
                            Display.create((PixelFormat)new PixelFormat(n6, 0, 32, 0, 0));
                            Logger.log("ZBuffer depth is now set to 32bpp!", 1);
                            Config.glZBufferDepth = 32;
                        }
                        catch (Throwable throwable3) {
                            vector.addElement(throwable3);
                            try {
                                Display.create((PixelFormat)new PixelFormat(n6, 0, 16, 0, 0));
                                Logger.log("ZBuffer depth is now set to 16bpp!", 1);
                                Config.glZBufferDepth = 16;
                            }
                            catch (Throwable throwable4) {
                                vector.addElement(throwable4);
                                try {
                                    Logger.log("Does this machine actually support OpenGL? Trying everything at lowest settings now!", 1);
                                    Display.create((PixelFormat)new PixelFormat(16, 0, 16, 0, 0));
                                }
                                catch (Exception exception) {
                                    vector.addElement(exception);
                                    if (Config.glVerbose) {
                                        for (int i = 0; i < vector.size(); ++i) {
                                            Throwable throwable5 = (Throwable)vector.get(i);
                                            throwable5.printStackTrace();
                                        }
                                    }
                                    if (Config.glUseUnappropriateModes) {
                                        try {
                                            Logger.log("Config.glUseUnappropriateModes is true...trying that...", 1);
                                            Display.create((PixelFormat)new PixelFormat());
                                        }
                                        catch (Exception exception2) {
                                            vector.addElement(exception2);
                                            GLHelper.printDriver();
                                            Logger.log("...but to no avail!", 0);
                                            throw exception;
                                        }
                                    }
                                    GLHelper.printDriver();
                                    Logger.log("Unable to set any valid videomode on this machine!", 0);
                                    throw exception;
                                }
                            }
                        }
                    }
                } else {
                    Display.create((PixelFormat)pixelFormat);
                }
                return bl;
            }
        }
        catch (Exception exception) {
            Logger.log("Can't set videomode - try different settings!", 0);
            if (exception instanceof ArrayIndexOutOfBoundsException) return false;
            if (exception instanceof NullPointerException) return false;
            exception.printStackTrace();
            return false;
        }
    }
}

