/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.AWTGLRenderer;
import com.threed.jpct.BlittingWrapper;
import com.threed.jpct.Config;
import com.threed.jpct.IPaintListener;
import com.threed.jpct.IPostProcessor;
import com.threed.jpct.IRenderer;
import com.threed.jpct.ISomeImageBuffer;
import com.threed.jpct.IntegerC;
import com.threed.jpct.LegacyRenderer;
import com.threed.jpct.Logger;
import com.threed.jpct.Plane;
import com.threed.jpct.ProxyFrameBuffer;
import com.threed.jpct.SoftGLRenderer;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.VersionHelper;
import com.threed.jpct.VideoMode;
import com.threed.jpct.VisListManager;
import com.threed.jpct.threading.WorkLoad;
import com.threed.jpct.threading.Worker;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.Vector;

public class FrameBuffer
implements Serializable {
    private static boolean useJOGL = false;
    private static final long serialVersionUID = 4L;
    public static final int MEMORYIMAGESOURCE = 0;
    public static final int BUFFEREDIMAGE = 1;
    public static final int SAMPLINGMODE_GL_AA_4X = 40;
    public static final int SAMPLINGMODE_GL_AA_2X = 20;
    public static final int SAMPLINGMODE_OGSS = 1;
    public static final int SAMPLINGMODE_OGSS_FAST = 3;
    public static final int SAMPLINGMODE_OGUS = 2;
    public static final int SAMPLINGMODE_NORMAL = 0;
    public static final int SAMPLINGMODE_HARDWARE_ONLY = 0;
    public static final boolean BOUNDINGBOX_USED = true;
    public static final boolean BOUNDINGBOX_NOT_USED = false;
    public static final boolean OPAQUE_BLITTING = false;
    public static final boolean TRANSPARENT_BLITTING = true;
    public static final String SUPPORT_FOR_RGB_SCALING = "GL_ARB_texture_env_combine";
    public static final String SUPPORT_FOR_SHADOW_MAPPING = "GL_ARB_shadow";
    public static final int BUFFER_ACCESS_COMBINED = 0;
    public static final int BUFFER_ACCESS_SPLITTED = 1;
    public static final int BLITTING_TARGET_FRONT = 0;
    public static final int BLITTING_TARGET_BACK = 1;
    public static final Object SYNCHRONIZER;
    private static final int ALPHA = -16777216;
    private static final int SUB_ALPHA = 0xFFFFFF;
    long frameCount = 0L;
    boolean emulateOpenGL = false;
    float middleX;
    float middleY;
    boolean useBb;
    int bbXl;
    int bbXr;
    int bbYo;
    int bbYu;
    int bbXlL;
    int bbXrL;
    int bbYoL;
    int bbYuL;
    int bbXlD;
    int bbXrD;
    int bbYoD;
    int bbYuD;
    int bbXd;
    int bbYd;
    int[] pixels;
    int width;
    int height;
    int[] xstart;
    int[] xend;
    int[] exXstart;
    int[] exXend;
    int[] exXstart2;
    int[] exXend2;
    float[] zhigh;
    float[] exZlow;
    float[] exZlow2;
    int blittingTarget = 0;
    transient IRenderer softRend = null;
    transient IRenderer glRend = null;
    transient ProxyFrameBuffer proxy = null;
    transient boolean hasRenderTarget = false;
    transient Texture renderTarget = null;
    transient long displayCycle = 0L;
    boolean canvasMode = false;
    transient int[] sliStart = null;
    transient long[] sliTimes = null;
    protected int[] zbuffer;
    private int owidth;
    private int oheight;
    private transient MemoryImageSource source = null;
    private transient MemoryImageSource sourceOut = null;
    private Image output;
    private int length;
    private int[] pixelsOut;
    private boolean useBufferedImage;
    private boolean oversampling;
    private int samplingmode;
    private int bufferType = 0;
    private boolean initialized;
    private int fillingMode = 0;
    private int[] fogLookUp = null;
    private float fogR = -1.0f;
    private float fogG = -1.0f;
    private float fogB = -1.0f;
    private float fogDistance = -1.0f;
    private boolean currentFoggingState = false;
    private transient Vector usedBy = new Vector(2);
    private transient Vector postProcessors = new Vector(1);
    private Long id = null;
    private static long sid;
    private boolean ignoreInit = false;
    VersionHelper versionHelper = null;
    private transient BlittingWrapper blitWrap = null;
    private Object defaultLock = new Object();
    private ClearyLoad[] clearLoads = null;
    private boolean singleThreaded = false;
    private Drawer[] drawers = null;
    int virtualHeight = -1;
    int virtualWidth = -1;

    public FrameBuffer(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    FrameBuffer(int n, int n2, int n3, Texture texture) {
        Object object;
        Class<?> clazz;
        boolean bl;
        this.id = new Long(sid);
        ++sid;
        boolean bl2 = bl = texture != null;
        if (bl) {
            n3 = 0;
            this.singleThreaded = true;
        }
        this.initialized = true;
        this.bbXlL = 99999999;
        this.bbXrL = 0;
        this.bbYuL = 0;
        this.bbYoL = 99999999;
        this.useBb = true;
        this.oversampling = n3 != 0;
        this.samplingmode = 0;
        int n4 = n;
        int n5 = n2;
        this.owidth = n;
        this.oheight = n2;
        this.bbXl = 0;
        this.bbXr = n;
        this.bbYu = n2;
        this.bbYo = 0;
        if (n3 == 1) {
            n <<= 1;
            n2 <<= 1;
            this.samplingmode = 1;
        }
        if (n3 == 2) {
            n >>= 1;
            n2 >>= 1;
            this.samplingmode = 2;
        }
        if (n3 == 3) {
            n = (int)((float)n * 1.5f);
            n2 = (int)((float)n2 * 1.5f);
            this.samplingmode = 3;
        }
        if (n3 >= 20) {
            this.oversampling = false;
            this.samplingmode = n3;
        }
        this.length = n * n2;
        this.width = n;
        this.height = n2;
        this.middleX = (float)this.width / 2.0f;
        this.middleY = (float)this.height / 2.0f;
        this.zbuffer = new int[this.length];
        this.xstart = new int[this.height];
        this.xend = new int[this.height];
        this.zhigh = new float[this.height];
        this.exXstart = new int[this.height];
        this.exXend = new int[this.height];
        this.exZlow = new float[this.height];
        this.exXstart2 = new int[this.height];
        this.exXend2 = new int[this.height];
        this.exZlow2 = new float[this.height];
        String string = System.getProperty("java.version");
        if (!bl) {
            Logger.log("Java version is: " + string, 2);
        }
        if (string.startsWith("1.1") || string.startsWith("1.0")) {
            if (!bl) {
                Logger.log("-> no support for BufferedImage", 2);
            }
            this.useBufferedImage = false;
            try {
                clazz = Class.forName("com.threed.jpct.VersionHelper11");
                this.versionHelper = (VersionHelper)clazz.newInstance();
            }
            catch (Exception exception) {
                Logger.log(exception.toString(), 0);
            }
        } else {
            if (!bl) {
                Logger.log("-> support for BufferedImage", 2);
            }
            this.useBufferedImage = !Config.neverUseBufferedImage;
            boolean bl3 = false;
            try {
                object = new Float(string.substring(0, 3));
                if ((double)((Float)object).floatValue() >= 1.5) {
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl3) {
                try {
                    object = Class.forName("com.threed.jpct.VersionHelper5");
                    this.versionHelper = (VersionHelper)((Class)object).newInstance();
                }
                catch (Exception exception) {
                    Logger.log(exception.toString(), 0);
                }
            } else {
                try {
                    object = Class.forName("com.threed.jpct.VersionHelper2");
                    this.versionHelper = (VersionHelper)((Class)object).newInstance();
                }
                catch (Exception exception) {
                    Logger.log(exception.toString(), 0);
                }
            }
        }
        if (!this.useBufferedImage) {
            if (!bl) {
                Logger.log("-> using MemoryImageSource", 2);
            }
        } else if (!bl) {
            Logger.log("-> using BufferedImage", 2);
        }
        if (!this.useBufferedImage) {
            clazz = null;
            object = null;
            try {
                clazz = Class.forName("com.threed.jpct.MemoryImageBuffer");
                object = (ISomeImageBuffer)clazz.newInstance();
            }
            catch (Exception exception) {
                Logger.log(exception.toString(), 0);
                this.initialized = false;
            }
            if (this.initialized) {
                if (this.oversampling) {
                    this.pixels = new int[this.length];
                    object.create(n4, n5);
                    this.sourceOut = object.getSource();
                    this.pixelsOut = object.getPixels();
                } else {
                    object.create(n, n2);
                    this.source = object.getSource();
                    this.pixels = object.getPixels();
                }
                this.bufferType = object.getType();
                this.output = object.getImage();
            }
        } else {
            clazz = null;
            object = null;
            try {
                clazz = Class.forName("com.threed.jpct.BufferedImageBuffer");
                object = (ISomeImageBuffer)clazz.newInstance();
            }
            catch (Exception exception) {
                Logger.log(exception.toString(), 0);
                this.initialized = false;
            }
            if (this.initialized) {
                if (!this.oversampling) {
                    object.create(n, n2);
                    this.pixels = object.getPixels();
                } else {
                    object.create(n4, n5);
                    this.pixelsOut = object.getPixels();
                    this.pixels = new int[this.length];
                }
                this.output = object.getImage();
                this.bufferType = object.getType();
            }
        }
        if (!bl) {
            this.ignoreInit = true;
            this.enableRenderer(1, 1);
            this.ignoreInit = false;
        }
    }

    public Long getID() {
        return this.id;
    }

    public static VideoMode[] getVideoModes(int n) {
        switch (n) {
            case 2: {
                try {
                    IRenderer iRenderer = null;
                    iRenderer = !useJOGL ? (IRenderer)Class.forName("com.threed.jpct.GLRenderer").newInstance() : (IRenderer)Class.forName("com.threed.jpct.JOGLRenderer").newInstance();
                    return iRenderer.getAvailableVideoModes();
                }
                catch (Exception exception) {
                    Logger.log("Error getting video modes for OpenGL: " + exception.toString(), 0);
                    break;
                }
            }
            case 1: {
                try {
                    String string = "com.threed.jpct.SoftGLRenderer";
                    IRenderer iRenderer = (IRenderer)Class.forName(string).newInstance();
                    return iRenderer.getAvailableVideoModes();
                }
                catch (Exception exception) {
                    Logger.log("Error getting video modes for software: " + exception.toString(), 0);
                }
            }
        }
        return null;
    }

    public boolean isInitialized() {
        boolean bl = this.initialized;
        if (this.softRend != null) {
            bl &= this.softRend.isInitialized();
        }
        if (this.glRend != null) {
            bl &= this.glRend.isInitialized();
        }
        return bl;
    }

    public void setBlittingTarget(int n) {
        this.blittingTarget = n;
    }

    public void enableRenderer(int n) {
        this.enableRenderer(n, 1);
    }

    public Canvas enableGLCanvasRenderer() {
        this.enableRenderer(2, 1, true);
        Object[] objectArray = new Object[1];
        this.glRend.execute(11, objectArray);
        return (Canvas)objectArray[0];
    }

    public void enableRenderer(int n, int n2) {
        this.enableRenderer(n, n2, false);
    }

    public void setRenderTarget(int n) {
        if (n == -1) {
            this.setRenderTarget(null);
        } else {
            this.setRenderTarget(TextureManager.getInstance().getTextureByID(n));
        }
    }

    public void setRenderTarget(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (n == -1) {
            this.setRenderTarget(null);
        } else {
            this.setRenderTarget(TextureManager.getInstance().getTextureByID(n), n2, n3, n4, n5, bl);
        }
    }

    public void setRenderTarget(Texture texture) {
        this.setRenderTarget(texture, -1, -1, -1, -1, true);
    }

    public void setRenderTarget(Texture texture, int n, int n2, int n3, int n4, boolean bl) {
        if (!(Config.glUseFBO || texture == null || texture.getWidth() <= this.getOutputWidth() && texture.getHeight() <= this.getOutputHeight())) {
            Logger.log("Can't render into a texture larger than the current framebuffer!", 0);
            return;
        }
        if (this.glRend != null) {
            if (texture != null && texture.mipmap) {
                texture.setMipmap(false);
            }
            Object[] objectArray = new Object[]{texture, this, IntegerC.valueOf(n), IntegerC.valueOf(n2), IntegerC.valueOf(n3), IntegerC.valueOf(n4), Config.booleanValueOf(bl)};
            this.glRend.execute(18, objectArray);
        }
        if (this.softRend != null) {
            if (texture != null) {
                if (texture.mipmap) {
                    texture.setMipmap(false);
                }
                this.proxy = ProxyFrameBuffer.getInstance(texture, this);
            } else {
                this.proxy = null;
            }
        }
        this.hasRenderTarget = texture != null;
        this.renderTarget = texture;
    }

    public void removeRenderTarget() {
        if (this.hasRenderTarget) {
            this.setRenderTarget(null);
        }
    }

    public void setVirtualDimensions(int n, int n2) {
        this.virtualHeight = n2;
        this.virtualWidth = n;
    }

    public void addPostProcessor(IPostProcessor iPostProcessor) {
        if (iPostProcessor.isInitialized()) {
            Logger.log("Post processor has already been initialized!", 0);
        } else {
            this.postProcessors.addElement(iPostProcessor);
        }
    }

    public void removePostProcessor(IPostProcessor iPostProcessor) {
        this.postProcessors.removeElement(iPostProcessor);
        Object[] objectArray = new Object[]{this, iPostProcessor};
        if (this.glRend != null) {
            this.glRend.execute(17, objectArray);
        }
        if (this.softRend != null) {
            iPostProcessor.dispose();
        }
    }

    public void removeAllPostProcessors() {
        for (int i = 0; i < this.postProcessors.size(); ++i) {
            this.removePostProcessor((IPostProcessor)this.postProcessors.elementAt(i));
        }
    }

    public void runPostProcessors() {
        if (this.postProcessors == null) {
            this.postProcessors = new Vector(1);
        }
        boolean bl = false;
        if (this.postProcessors.size() > 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this;
            for (int i = 0; i < this.postProcessors.size(); ++i) {
                IPostProcessor iPostProcessor = (IPostProcessor)this.postProcessors.elementAt(i);
                objectArray[1] = iPostProcessor;
                if (this.glRend != null) {
                    this.glRend.execute(16, objectArray);
                }
                if (this.softRend == null) continue;
                if (this.proxy == null) {
                    if (!iPostProcessor.isInitialized()) {
                        iPostProcessor.init(this);
                    }
                    iPostProcessor.process();
                    bl = true;
                    continue;
                }
                Logger.log("Can't run a post processor on a software renderer's render target!", 1);
            }
        }
        if (bl) {
            this.refresh();
        }
    }

    public void setPaintListener(IPaintListener iPaintListener) {
        if (this.glRend != null) {
            this.glRend.setPaintListener(iPaintListener);
        }
        if (this.softRend != null) {
            this.softRend.setPaintListener(iPaintListener);
        }
    }

    public void setPaintListenerState(boolean bl) {
        Object[] objectArray = new Object[]{Config.booleanValueOf(bl)};
        if (this.glRend != null) {
            this.glRend.execute(24, objectArray);
        }
        if (this.softRend != null) {
            this.softRend.execute(24, objectArray);
        }
    }

    private void enableRenderer(int n, int n2, boolean bl) {
        switch (n) {
            case 1: {
                boolean bl2 = this.emulateOpenGL = n2 == 1;
                if (this.softRend != null) {
                    this.softRend.dispose();
                }
                this.drawers = null;
                this.clearLoads = null;
                this.softRend = null;
                try {
                    String string = "com.threed.jpct.LegacyRenderer";
                    if (this.emulateOpenGL) {
                        string = "com.threed.jpct.SoftGLRenderer";
                    }
                    this.softRend = (IRenderer)Class.forName(string).newInstance();
                    if (!this.oversampling && this.samplingmode >= 20 && !this.ignoreInit) {
                        Logger.log("Can't use a software renderer on a framebuffer with a hardware sampling mode", 0);
                    }
                    this.softRend.init(this.owidth, this.oheight, 24, 32, 0);
                }
                catch (Exception exception) {
                    Logger.log(exception.toString(), 0);
                }
                this.removeAllPostProcessors();
                break;
            }
            case 2: {
                if (n2 == 2) {
                    Logger.log("Legacy mode for the OpenGL renderer is no longer supported!", 0);
                }
                if (this.glRend != null) {
                    this.glRend.dispose();
                }
                this.glRend = null;
                try {
                    String string = null;
                    if (bl) {
                        if (useJOGL) {
                            string = "com.threed.jpct.JOGLRenderer";
                            Logger.log("Using JOGL's GLCanvas", 2);
                        } else {
                            string = "com.threed.jpct.AWTGLRenderer";
                            Logger.log("Using LWJGL's AWTGLCanvas", 2);
                        }
                        this.canvasMode = true;
                    } else {
                        if (useJOGL) {
                            Logger.log("Using a native GL renderer isn't possible when using JOGL! Remove glfacade.jar from the classpath!", 0);
                            return;
                        }
                        string = Config.useMultipleThreads ? "com.threed.jpct.AWTGLRenderer" : "com.threed.jpct.GLRenderer";
                        this.canvasMode = false;
                    }
                    this.glRend = (IRenderer)Class.forName(string).newInstance();
                    if (Config.useMultipleThreads && !bl) {
                        this.glRend.execute(14, new Object[]{Boolean.FALSE});
                    }
                    if (this.oversampling && this.samplingmode != 0) {
                        Logger.log("Can't use a hardware renderer on a framebuffer with a software sampling mode", 0);
                    }
                    this.glRend.init(this.owidth, this.oheight, Config.glColorDepth, Config.glZBufferDepth, this.samplingmode / 10);
                }
                catch (Exception exception) {
                    Logger.log(exception.toString(), 0);
                }
                this.removeAllPostProcessors();
            }
        }
    }

    public void disableRenderer(int n) {
        switch (n) {
            case 1: {
                if (this.softRend == null) break;
                this.clearLoads = null;
                this.drawers = null;
                if (this.blitWrap != null) {
                    this.blitWrap.dispose();
                }
                this.blitWrap = null;
                this.softRend.dispose();
                this.softRend = null;
                this.removeAllPostProcessors();
                break;
            }
            case 2: {
                if (this.glRend == null) break;
                this.glRend.dispose();
                this.glRend = null;
                this.removeAllPostProcessors();
            }
        }
    }

    public void dispose() {
        this.checkListeners();
        this.removeListeners();
        this.removeAllPostProcessors();
        if (this.blitWrap != null) {
            this.blitWrap.dispose();
        }
        if (this.softRend != null) {
            this.disableRenderer(1);
        }
        this.clearLoads = null;
        this.blitWrap = null;
        this.drawers = null;
    }

    public boolean usesRenderer(int n) {
        switch (n) {
            case 1: {
                return this.softRend != null;
            }
            case 2: {
                return this.glRend != null;
            }
        }
        return false;
    }

    public int getMaxTextureSize() {
        if (this.glRend != null) {
            Object[] objectArray = new Object[]{"dummy"};
            this.glRend.execute(25, objectArray);
            return (Integer)objectArray[0];
        }
        return 8192;
    }

    public boolean supports(String string) {
        if (string.equals(SUPPORT_FOR_RGB_SCALING)) {
            boolean bl = true;
            if (this.softRend != null) {
                bl = this.emulateOpenGL;
            }
            if (this.glRend != null) {
                Object[] objectArray = new Object[]{string};
                this.glRend.execute(10, objectArray);
                bl &= ((Boolean)objectArray[0]).booleanValue();
            }
            return bl;
        }
        if (string.equals(SUPPORT_FOR_SHADOW_MAPPING)) {
            boolean bl = true;
            if (this.softRend != null) {
                return false;
            }
            if (this.glRend != null) {
                Object[] objectArray = new Object[]{string};
                this.glRend.execute(10, objectArray);
                bl = (Boolean)objectArray[0];
            }
            return bl;
        }
        return false;
    }

    public int getSamplingMode() {
        return this.samplingmode;
    }

    public int getOutputWidth() {
        return this.owidth;
    }

    public int getOutputHeight() {
        return this.oheight;
    }

    public float getMiddleX() {
        return this.middleX;
    }

    public float getMiddleY() {
        return this.middleY;
    }

    public void setBoundingBoxMode(boolean bl) {
        this.useBb = bl;
    }

    public void clear() {
        if (this.glRend != null && this.softRend == null) {
            this.clear(null);
        } else {
            this.clear(Color.black);
        }
    }

    public void clearZBufferOnly() {
        if (this.glRend != null) {
            this.glRend.execute(15, null);
        }
        if (this.proxy != null) {
            this.proxy.clearZBufferOnly();
        } else if (this.softRend != null) {
            this.clearSoftware(Color.black, true);
        }
    }

    public void clear(Color color) {
        if (this.proxy != null) {
            this.proxy.clear(color);
        } else if (this.softRend != null) {
            this.clearSoftware(color);
        }
        if (this.glRend != null) {
            this.clearHardware(color);
        }
    }

    public void update() {
        this.incCounter();
        if (this.proxy != null) {
            this.proxy.update();
        } else if (this.softRend != null) {
            this.updateSoftware();
        }
    }

    public void setBufferAccess(int n) {
        this.fillingMode = n;
    }

    public void optimizeBufferAccess() {
        this.fillingMode = 0;
        int n = 0;
        int n2 = 0;
        this.clearSoftware(Color.black);
        this.clearSoftware(Color.black);
        this.clearSoftware(Color.black);
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 500L) {
            this.clearSoftware(Color.black);
            ++n;
        }
        this.fillingMode = 1;
        this.clearSoftware(Color.black);
        this.clearSoftware(Color.black);
        this.clearSoftware(Color.black);
        l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 500L) {
            this.clearSoftware(Color.black);
            ++n2;
        }
        if (n > (n2 = (int)((float)n2 + (float)n2 / 40.0f))) {
            this.fillingMode = 0;
            Logger.log(n + "-" + n2 + " -> using combined buffer access!", 2);
        } else {
            this.fillingMode = 1;
            Logger.log(n + "-" + n2 + " -> using splitted buffer access!", 2);
        }
    }

    public Image getOutputBuffer() {
        if (this.softRend != null) {
            return this.output;
        }
        if (this.glRend != null) {
            this.getPixels();
            if (this.bufferType == 0) {
                if (this.oversampling) {
                    this.sourceOut.newPixels(0, 0, this.owidth, this.oheight, false);
                } else {
                    this.source.newPixels(0, 0, this.width, this.height, false);
                }
            }
            return this.output;
        }
        return null;
    }

    public int[] getPixels() {
        if (this.softRend != null) {
            if (!this.oversampling) {
                return this.pixels;
            }
            return this.pixelsOut;
        }
        Object[] objectArray = new Object[]{this, !this.oversampling ? (Object)this.pixels : (Object)this.pixelsOut};
        this.glRend.execute(6, objectArray);
        return (int[])objectArray[1];
    }

    public void refresh() {
        if (this.softRend != null && !this.useBufferedImage) {
            if (!this.oversampling) {
                this.source.newPixels(0, 0, this.width, this.height, false);
            } else {
                this.sourceOut.newPixels(0, 0, this.owidth, this.oheight, false);
            }
        }
    }

    public Object getLock() {
        if (this.glRend == null || !(this.glRend instanceof AWTGLRenderer)) {
            return this.defaultLock;
        }
        Object object = ((AWTGLRenderer)this.glRend).getLock();
        return object != null ? object : this.defaultLock;
    }

    public Graphics getGraphics() {
        Graphics graphics = null;
        try {
            graphics = this.output.getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return graphics;
    }

    public int getType() {
        return this.bufferType;
    }

    public void blit(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.glRend != null) {
            Object[] objectArray = new Object[]{texture, this, IntegerC.valueOf(n), IntegerC.valueOf(n2), IntegerC.valueOf(n3), IntegerC.valueOf(n4), IntegerC.valueOf(n5), IntegerC.valueOf(n6), Config.booleanValueOf(bl)};
            this.glRend.execute(4, objectArray);
        }
        if (this.softRend != null) {
            this.blit(texture.texels, texture.width, texture.height, n, n2, n3, n4, n5, n6, bl);
        }
    }

    public void blit(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, Color color) {
        if (this.glRend != null) {
            Object[] objectArray = new Object[18];
            objectArray[0] = texture;
            objectArray[1] = this;
            objectArray[2] = IntegerC.valueOf(n);
            objectArray[3] = IntegerC.valueOf(n2);
            objectArray[4] = IntegerC.valueOf(n3);
            objectArray[5] = IntegerC.valueOf(n4);
            objectArray[6] = IntegerC.valueOf(n5);
            objectArray[7] = IntegerC.valueOf(n6);
            objectArray[8] = Config.booleanValueOf(n9 > -1);
            objectArray[11] = IntegerC.valueOf(n7);
            objectArray[12] = IntegerC.valueOf(n8);
            objectArray[13] = IntegerC.valueOf(n9);
            objectArray[14] = Config.booleanValueOf(bl);
            if (color != null) {
                objectArray[15] = IntegerC.valueOf(color.getRed());
                objectArray[16] = IntegerC.valueOf(color.getGreen());
                objectArray[17] = IntegerC.valueOf(color.getBlue());
            } else {
                Integer n10 = IntegerC.valueOf(255);
                objectArray[15] = n10;
                objectArray[16] = n10;
                objectArray[17] = n10;
            }
            this.glRend.execute(4, objectArray);
        }
        if (this.softRend != null) {
            if (this.blitWrap == null) {
                this.blitWrap = new BlittingWrapper(this);
            }
            this.blitWrap.blit(texture, n, n2, n3, n4, n5, n6, n7, n8, n9, bl, color);
        }
    }

    public void blit(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        if (n3 >= 0 && n3 < n && n4 >= 0 && n4 < n2 && n3 + n7 <= n && n4 + n8 <= n2) {
            if (this.proxy != null) {
                this.proxy.blit(nArray, n, n2, n3, n4, n5, n6, n7, n8, bl);
            } else if (this.softRend != null) {
                this.blitSoftware(nArray, n, n3, n4, n5, n6, n7, n8, bl);
            }
            if (this.glRend != null) {
                Object[] objectArray = new Object[]{nArray, this, IntegerC.valueOf(n3), IntegerC.valueOf(n4), IntegerC.valueOf(n5), IntegerC.valueOf(n6), IntegerC.valueOf(n7), IntegerC.valueOf(n8), Config.booleanValueOf(bl), IntegerC.valueOf(n), IntegerC.valueOf(n2)};
                this.glRend.execute(7, objectArray);
            }
        } else {
            Logger.log("Blitting region out of bounds", 0);
        }
    }

    public void display(Graphics graphics) {
        this.display(graphics, 0);
    }

    public void display(Graphics graphics, int n) {
        this.display(graphics, 0, n);
    }

    public void display(Graphics graphics, int n, int n2) {
        this.incCounter();
        if (this.proxy != null) {
            this.proxy.copy();
        } else if (this.softRend != null) {
            if (!Config.useMultipleThreads || !Config.useMultiThreadedBlitting || this.softRend instanceof LegacyRenderer) {
                graphics.drawImage(this.output, n, n2, null);
            } else {
                int n3;
                if (this.drawers == null) {
                    this.drawers = new Drawer[Config.maxNumberOfCores];
                    int n4 = 0;
                    n3 = this.oheight / Config.maxNumberOfCores;
                    int n5 = 0;
                    for (int i = 0; i < this.drawers.length; ++i) {
                        n5 = n4 + n3;
                        if (i == this.drawers.length - 1) {
                            n5 = this.oheight;
                        }
                        Drawer drawer = new Drawer(this.output, n4, n5, this.owidth);
                        n4 += n3;
                        this.drawers[i] = drawer;
                    }
                }
                Worker worker = ((SoftGLRenderer)this.softRend).initWorker();
                for (n3 = 0; n3 < this.drawers.length - 1; ++n3) {
                    Drawer drawer = this.drawers[n3];
                    drawer.set(graphics, n2, n);
                    worker.add(drawer);
                }
                Drawer drawer = this.drawers[this.drawers.length - 1];
                drawer.set(graphics, n2, n);
                drawer.doWork();
                worker.waitForAll();
            }
        }
        if (this.glRend != null) {
            this.glRend.execute(1, null);
        }
    }

    private void incCounter() {
        if (!this.hasRenderTarget || !(this.glRend instanceof AWTGLRenderer)) {
            ++this.displayCycle;
        }
    }

    public void displayGLOnly() {
        if (this.softRend == null && this.glRend != null) {
            this.display(null, 0);
        } else {
            Logger.log("displayGLOnly() shouldn't be called without OpenGL support being (solely) used (" + this.softRend + "/" + this.glRend + ")", 1);
        }
    }

    public void setClippingPlane(int n, Plane plane) {
        if (this.glRend != null && n < 6) {
            Object[] objectArray = new Object[]{new Integer(n), plane.getPlaneEquation()};
            this.glRend.execute(26, objectArray);
        }
    }

    public void removeClippingPlane(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        this.glRend.execute(27, objectArray);
    }

    final void register(VisListManager visListManager) {
        this.checkListeners();
        if (!this.usedBy.contains(visListManager)) {
            this.usedBy.addElement(visListManager);
        }
    }

    final void expandBoundingBox() {
        this.bbXl = 0;
        this.bbXr = this.owidth;
        this.bbYu = this.oheight;
        this.bbYo = 0;
    }

    final void drawLine(float f, float f2, float f3, float f4, int n) {
        float f5 = 0.0f;
        float f6 = f3 - f;
        float f7 = f4 - f2;
        float f8 = 1.0f;
        float f9 = 1.0f;
        if (f6 != 0.0f) {
            f9 = f7 / f6;
        }
        if (f7 != 0.0f) {
            f8 = f6 / f7;
        }
        if (f3 < 0.0f && f < 0.0f || f >= (float)this.width && f3 >= (float)this.width || f4 < 0.0f && f2 < 0.0f || f4 >= (float)this.height && f2 >= (float)this.height) {
            return;
        }
        if (Math.abs(f8) > Math.abs(f9)) {
            if (f > f3) {
                f5 = f;
                f = f3;
                f3 = f5;
                f5 = f2;
                f2 = f4;
                f4 = f5;
            }
            if (f < 0.0f) {
                f2 += f9 * -f;
                f = 0.0f;
            }
            if (f3 >= (float)this.width) {
                f4 += f9 * (f3 - (float)(this.width + 1));
                f3 = this.width - 1;
            }
            int n2 = (int)(f2 * 262144.0f);
            int n3 = (int)(f9 * 262144.0f);
            int n4 = (int)f;
            int n5 = (int)f3;
            int n6 = this.height << 18;
            for (int i = n4; i <= n5; ++i) {
                if (n2 >= 0 && n2 < n6) {
                    this.pixels[(n2 >> 18) * this.width + i] = n;
                }
                n2 += n3;
            }
        } else {
            if (f2 > f4) {
                f5 = f;
                f = f3;
                f3 = f5;
                f5 = f2;
                f2 = f4;
                f4 = f5;
            }
            if (f2 < 0.0f) {
                f += f8 * -f2;
                f2 = 0.0f;
            }
            if (f4 >= (float)this.height) {
                f3 += f8 * (f4 - (float)(this.height + 1));
                f4 = this.height - 1;
            }
            int n7 = (int)(f * 262144.0f);
            int n8 = (int)(f8 * 262144.0f);
            int n9 = (int)f2;
            int n10 = (int)f4;
            n10 *= this.width;
            int n11 = this.width << 18;
            for (int i = n9 *= this.width; i <= n10; i += this.width) {
                if (n7 >= 0 && n7 < n11) {
                    this.pixels[i + (n7 >> 18)] = n;
                }
                n7 += n8;
            }
        }
    }

    private final void updateSoftware() {
        if (this.useBb && !Config.blur) {
            --this.bbXl;
            ++this.bbXr;
            ++this.bbYu;
            --this.bbYo;
            this.bbXlD = this.bbXl < this.bbXlL ? this.bbXl : this.bbXlL;
            this.bbXrD = this.bbXr > this.bbXrL ? this.bbXr : this.bbXrL;
            this.bbYoD = this.bbYo < this.bbYoL ? this.bbYo : this.bbYoL;
            this.bbYuD = this.bbYu > this.bbYuL ? this.bbYu : this.bbYuL;
            this.bbXlL = this.bbXl;
            this.bbXrL = this.bbXr;
            this.bbYuL = this.bbYu;
            this.bbYoL = this.bbYo;
            this.bbXl = 99999999;
            this.bbXr = 0;
            this.bbYo = 99999999;
            this.bbYu = 0;
        }
        if (Config.blur) {
            this.bbXlD = 0;
            this.bbXrD = this.width - 1;
            this.bbYoD = 0;
            this.bbYuD = this.height - 1;
        }
        if (this.oversampling) {
            if (this.currentFoggingState) {
                this.applyPerPixelFog(this.fogR, this.fogG, this.fogB);
            }
            if (!Config.useMultipleThreads) {
                this.oversample(-1);
            } else {
                int n;
                Worker worker = ((SoftGLRenderer)this.softRend).initWorker();
                if (this.clearLoads == null) {
                    this.clearLoads = new ClearyLoad[Config.maxNumberOfCores];
                    for (n = 0; n < this.clearLoads.length; ++n) {
                        this.clearLoads[n] = new ClearyLoad();
                    }
                }
                for (n = 0; n < this.clearLoads.length - 1; ++n) {
                    ClearyLoad clearyLoad = this.clearLoads[n];
                    clearyLoad.setMode(false);
                    clearyLoad.setSection(n);
                    worker.add(clearyLoad);
                }
                ClearyLoad clearyLoad = this.clearLoads[Config.maxNumberOfCores - 1];
                clearyLoad.setSection(Config.maxNumberOfCores - 1);
                clearyLoad.setMode(false);
                clearyLoad.doWork();
                worker.waitForAll();
            }
        } else {
            if (this.currentFoggingState) {
                this.applyPerPixelFog(this.fogR, this.fogG, this.fogB);
            }
            if (!this.useBufferedImage) {
                if (!this.useBb) {
                    this.source.newPixels(0, 0, this.width, this.height, false);
                } else {
                    this.bbXd = this.bbXrD - this.bbXlD + 1;
                    this.bbYd = this.bbYuD - this.bbYoD + 1;
                    this.source.newPixels(this.bbXlD, this.bbYoD, this.bbXd, this.bbYd, false);
                }
            }
        }
    }

    private final void oversample(int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.length;
        int n8 = this.owidth * this.oheight;
        int n9 = n7;
        int n10 = n8;
        if (n >= 0) {
            float f = (float)this.oheight / (float)this.clearLoads.length;
            float f2 = 0.0f;
            float f3 = 0.0f;
            n3 = (int)(f * (float)n);
            n2 = (int)(f * (float)(n + 1));
            n3 &= 0xFFFFFFE;
            n2 &= 0xFFFFFFE;
            if (this.samplingmode == 1) {
                f2 = n3 * 2;
                f3 = n2 * 2;
            }
            if (this.samplingmode == 3) {
                f2 = (float)n3 * 1.5f;
                f3 = (float)n2 * 1.5f;
            }
            if (this.samplingmode == 2) {
                f2 = n3 / 2;
                f3 = n2 / 2;
            }
            n5 = n3 * this.owidth;
            n8 = n2 * this.owidth;
            n4 = (int)(f2 * (float)this.width);
            n7 = (int)(f3 * (float)this.width);
            if (n8 > n10) {
                n8 = n10;
            }
            if (n7 > n9) {
                n7 = n9;
            }
            n6 = n4 << 8;
        }
        int n11 = 0;
        try {
            if (this.samplingmode == 1) {
                while (n4 < n7) {
                    n2 = this.pixels[n4];
                    int n12 = this.pixels[n4 + 1];
                    int n13 = this.pixels[n4 + this.width];
                    int n14 = this.pixels[n4 + this.width + 1];
                    int n15 = n2 & 0xFF000000 | n12 & 0xFF000000 | n13 & 0xFF000000 | n14 & 0xFF000000;
                    int n16 = (n2 >> 16 & 0xFF) + (n12 >> 16 & 0xFF) + (n13 >> 16 & 0xFF) + (n14 >> 16 & 0xFF) >> 2 << 16;
                    int n17 = (n2 >> 8 & 0xFF) + (n12 >> 8 & 0xFF) + (n13 >> 8 & 0xFF) + (n14 >> 8 & 0xFF) >> 2 << 8;
                    n3 = (n2 & 0xFF) + (n12 & 0xFF) + (n13 & 0xFF) + (n14 & 0xFF) >> 2;
                    this.pixelsOut[n5] = n16 | n17 | n3 | n15;
                    ++n5;
                    n4 += 2;
                    if ((n11 += 2) < this.width) continue;
                    n11 = 0;
                    n4 += this.width;
                }
            } else if (this.samplingmode == 2) {
                boolean bl;
                boolean bl2 = bl = (this.owidth & 1) == 1;
                while (n4 < n7) {
                    this.pixelsOut[n5] = n2 = this.pixels[n4];
                    this.pixelsOut[n5 + 1] = n2;
                    this.pixelsOut[n5 + 1 + this.owidth] = n2;
                    this.pixelsOut[n5 + this.owidth] = n2;
                    n5 += 2;
                    ++n4;
                    if (++n11 < this.width) continue;
                    n11 = 0;
                    n5 += this.owidth;
                    if (!bl) continue;
                    ++n5;
                }
            } else {
                boolean bl;
                int n18 = n8;
                int n19 = 0;
                int n20 = this.width << 8;
                boolean bl3 = bl = (this.owidth & 1) == 1;
                while (n6 + n20 + 256 >> 8 < n7 && n5 < n18) {
                    n2 = this.pixels[n4];
                    int n21 = this.pixels[n6 + 256 >> 8];
                    int n22 = this.pixels[n6 + n20 >> 8];
                    int n23 = this.pixels[n6 + n20 + 256 >> 8];
                    int n24 = n2 & 0xFF000000 | n21 & 0xFF000000 | n22 & 0xFF000000 | n23 & 0xFF000000;
                    int n25 = (n2 >> 16 & 0xFF) + (n21 >> 16 & 0xFF) + (n22 >> 16 & 0xFF) + (n23 >> 16 & 0xFF) >> 2 << 16;
                    int n26 = (n2 >> 8 & 0xFF) + (n21 >> 8 & 0xFF) + (n22 >> 8 & 0xFF) + (n23 >> 8 & 0xFF) >> 2 << 8;
                    n3 = (n2 & 0xFF) + (n21 & 0xFF) + (n22 & 0xFF) + (n23 & 0xFF) >> 2;
                    this.pixelsOut[n5] = n25 | n26 | n3 | n24;
                    ++n5;
                    n6 += 384;
                    if (++n11 >= this.owidth) {
                        n11 = 0;
                        if (n19 & true) {
                            n6 += n20;
                        }
                        if (bl) {
                            n6 -= 128;
                        }
                        ++n19;
                    }
                    n4 = n6 >> 8;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.useBufferedImage) {
            if (!this.useBb) {
                this.sourceOut.newPixels(0, 0, this.owidth, this.oheight, false);
            } else if (this.samplingmode == 1) {
                this.bbXd = this.bbXrD - this.bbXlD + 3;
                this.bbYd = this.bbYuD - this.bbYoD + 3;
                this.sourceOut.newPixels(this.bbXlD >> 1, this.bbYoD >> 1, this.bbXd >> 1, this.bbYd >> 1, false);
            } else if (this.samplingmode == 2) {
                this.bbXd = this.bbXrD - this.bbXlD + 1;
                this.bbYd = this.bbYuD - this.bbYoD + 1;
                this.sourceOut.newPixels(this.bbXlD << 1, this.bbYoD << 1, this.bbXd << 1, this.bbYd << 1, false);
            } else {
                this.bbXd = this.bbXrD - this.bbXlD + 3;
                this.bbYd = this.bbYuD - this.bbYoD + 3;
                this.sourceOut.newPixels((int)((float)this.bbXlD / 1.5f), (int)((float)this.bbYoD / 1.5f), (int)((float)this.bbXd / 1.5f), (int)((float)this.bbYd / 1.5f), false);
            }
        }
    }

    private final void clearHardware(Color color) {
        Object[] objectArray = null;
        if (color != null) {
            objectArray = new Object[]{color};
        }
        this.glRend.execute(2, objectArray);
    }

    private final void clearSoftware(Color color) {
        this.clearSoftware(color, false);
    }

    private final void clearSoftware(Color color, boolean bl) {
        int n;
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = 255;
        n5 = this.versionHelper.getAlpha(color);
        ++this.frameCount;
        int n6 = this.length;
        for (n = 0; n < this.height; ++n) {
            this.xstart[n] = 99999999;
            this.xend[n] = -1;
            this.zhigh[n] = -2.1474836E9f;
            this.exXstart[n] = 99999999;
            this.exXend[n] = -1;
            this.exZlow[n] = 2.1474836E9f;
            this.exXstart2[n] = 99999999;
            this.exXend2[n] = -1;
            this.exZlow2[n] = 2.1474836E9f;
        }
        if (Config.blur) {
            this.blur();
        } else {
            n = n5 << 24 | n2 << 16 | n3 << 8 | n4;
            if (!Config.isIndoor && !bl) {
                int[] nArray = this.zbuffer;
                int[] nArray2 = this.pixels;
                if (this.fillingMode == 1 && !Config.useMultipleThreads) {
                    int n7;
                    for (n7 = 0; n7 < n6; ++n7) {
                        nArray[n7] = -2147483647;
                    }
                    for (n7 = 0; n7 < n6; ++n7) {
                        nArray2[n7] = n;
                    }
                } else if (!Config.useMultipleThreads || this.singleThreaded || this.softRend instanceof LegacyRenderer) {
                    for (int i = 0; i < n6; ++i) {
                        nArray[i] = -2147483647;
                        nArray2[i] = n;
                    }
                } else {
                    int n8;
                    Worker worker = ((SoftGLRenderer)this.softRend).initWorker();
                    if (this.clearLoads == null) {
                        this.clearLoads = new ClearyLoad[Config.maxNumberOfCores];
                        for (n8 = 0; n8 < this.clearLoads.length; ++n8) {
                            this.clearLoads[n8] = new ClearyLoad();
                        }
                    }
                    for (n8 = 0; n8 < this.clearLoads.length - 1; ++n8) {
                        ClearyLoad clearyLoad = this.clearLoads[n8];
                        clearyLoad.setMode(true);
                        clearyLoad.setSection(n8);
                        clearyLoad.setColor(n, false);
                        worker.add(clearyLoad);
                    }
                    ClearyLoad clearyLoad = this.clearLoads[Config.maxNumberOfCores - 1];
                    clearyLoad.setSection(Config.maxNumberOfCores - 1);
                    clearyLoad.setMode(true);
                    clearyLoad.setColor(n, false);
                    clearyLoad.doWork();
                    worker.waitForAll();
                }
            } else if (!Config.zTrick) {
                if (!Config.useMultipleThreads || this.singleThreaded || this.softRend instanceof LegacyRenderer) {
                    int[] nArray = this.zbuffer;
                    for (int i = 0; i < n6; ++i) {
                        nArray[i] = -2147483647;
                    }
                } else {
                    int n9;
                    Worker worker = ((SoftGLRenderer)this.softRend).initWorker();
                    if (this.clearLoads == null) {
                        this.clearLoads = new ClearyLoad[Config.maxNumberOfCores];
                        for (n9 = 0; n9 < this.clearLoads.length; ++n9) {
                            this.clearLoads[n9] = new ClearyLoad();
                        }
                    }
                    for (n9 = 0; n9 < this.clearLoads.length - 1; ++n9) {
                        ClearyLoad clearyLoad = this.clearLoads[n9];
                        clearyLoad.setMode(true);
                        clearyLoad.setSection(n9);
                        clearyLoad.setColor(-1, true);
                        worker.add(clearyLoad);
                    }
                    ClearyLoad clearyLoad = this.clearLoads[Config.maxNumberOfCores - 1];
                    clearyLoad.setSection(Config.maxNumberOfCores - 1);
                    clearyLoad.setMode(true);
                    clearyLoad.setColor(-1, true);
                    clearyLoad.doWork();
                    worker.waitForAll();
                }
            }
        }
    }

    final void useFogging(float f, float f2, float f3, float f4) {
        if (this.fogLookUp == null) {
            this.fogLookUp = new int[32768];
        }
        if (f != this.fogDistance) {
            int n = (int)(1.0f / f * 2.1474836E9f);
            for (int i = 1; i < 32768; ++i) {
                this.fogLookUp[i] = n / i;
            }
        }
        this.fogR = f2;
        this.fogG = f3;
        this.fogB = f4;
        this.fogDistance = f;
        this.currentFoggingState = true;
    }

    final void dontUseFogging() {
        this.fogR = -1.0f;
        this.fogG = -1.0f;
        this.fogB = -1.0f;
        this.fogDistance = -1.0f;
        this.currentFoggingState = false;
    }

    private final void applyPerPixelFog(final float f, final float f2, final float f3) {
        int n = 0;
        int n2 = this.length;
        if (!Config.useMultipleThreads || this.softRend instanceof LegacyRenderer) {
            this.applyPerPixelFog(f, f2, f3, n, n2);
        } else {
            Worker worker = ((SoftGLRenderer)this.softRend).initWorker();
            final int n3 = this.length / Config.maxNumberOfCores;
            int n4 = 0;
            while (n4 < Config.maxNumberOfCores - 1) {
                final int n5 = n4++;
                worker.add(new WorkLoad(){
                    final int s;
                    final int e;
                    {
                        this.s = n5 * n3;
                        this.e = this.s + n3;
                    }

                    public void doWork() {
                        FrameBuffer.this.applyPerPixelFog(f, f2, f3, this.s, this.e);
                    }

                    public void done() {
                    }

                    public void error(Exception exception) {
                    }
                });
            }
            this.applyPerPixelFog(f, f2, f3, (Config.maxNumberOfCores - 1) * n3, this.length);
            worker.waitForAll();
        }
    }

    private final void applyPerPixelFog(float f, float f2, float f3, int n, int n2) {
        int[] nArray = this.pixels;
        int[] nArray2 = this.zbuffer;
        int n3 = (int)f;
        int n4 = (int)f2;
        int n5 = (int)f3;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > 255) {
            n5 = 255;
        }
        if (!Config.zTrick) {
            for (int i = n; i < n2; ++i) {
                int n6 = nArray2[i];
                if (n6 == -2147483647) continue;
                int n7 = this.fogLookUp[(n6 >> 17) + 16384];
                if (n7 > 65536) {
                    n7 = 65536;
                }
                int n8 = nArray[i] & 0xFFFFFF;
                int n9 = 65536 - n7;
                int n10 = n3 * n7 + n9 * (n8 >> 16) >> 16;
                int n11 = n4 * n7 + n9 * (n8 >> 8 & 0xFF) >> 16;
                int n12 = n5 * n7 + n9 * (n8 & 0xFF) >> 16;
                nArray[i] = n10 << 16 | n11 << 8 | n12 | 0xFF000000;
            }
        } else {
            int n13 = 1;
            if ((this.frameCount & 1L) == 1L) {
                n13 = -1;
            }
            for (int i = n; i < n2; ++i) {
                int n14;
                int n15 = nArray2[i] * n13;
                if (n15 < 0) {
                    n15 = 0;
                }
                if ((n14 = this.fogLookUp[n15 >> 16]) > 65536) {
                    n14 = 65536;
                }
                int n16 = nArray[i] & 0xFFFFFF;
                int n17 = 65536 - n14;
                int n18 = n3 * n14 + n17 * (n16 >> 16) >> 16;
                int n19 = n4 * n14 + n17 * (n16 >> 8 & 0xFF) >> 16;
                int n20 = n5 * n14 + n17 * (n16 & 0xFF) >> 16;
                nArray[i] = n18 << 16 | n19 << 8 | n20 | 0xFF000000;
            }
        }
    }

    private void blitSoftware(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int[] nArray2 = this.pixels;
        int n8 = this.width;
        int n9 = this.height;
        if (this.oversampling && this.blittingTarget == 0) {
            nArray2 = this.pixelsOut;
            n8 = this.owidth;
            n9 = this.oheight;
        }
        if (n4 < 0) {
            n2 += -n4;
            n6 -= -n4;
            n4 = 0;
        }
        if (n5 < 0) {
            n3 += -n5;
            n7 -= -n5;
            n5 = 0;
        }
        if (n4 + n6 > n8) {
            n6 -= n4 + n6 - n8;
        }
        if (n5 + n7 > n9) {
            n7 -= n5 + n7 - n9;
        }
        if (n4 < n8 && n5 < n9 && n6 > 0 && n7 > 0) {
            int n10 = n4 + n5 * n8;
            int n11 = n2 + n3 * n;
            if (!bl) {
                for (int i = 0; i < n7; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        nArray2[n10 + j] = nArray[n11 + j] | 0xFF000000;
                    }
                    n10 += n8;
                    n11 += n;
                }
            } else {
                for (int i = 0; i < n7; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        int n12 = nArray[n11 + j];
                        if ((n12 & 0xF0F0F0) == 0) continue;
                        nArray2[j + n10] = n12 | 0xFF000000;
                    }
                    n10 += n8;
                    n11 += n;
                }
            }
            if (!this.useBufferedImage) {
                if (!this.oversampling) {
                    this.source.newPixels(n4, n5, n6, n7, false);
                } else if (this.blittingTarget != 1) {
                    this.sourceOut.newPixels(n4, n5, n6, n7, false);
                }
            }
        }
    }

    private final void blur() {
        for (int i = 0; i < this.length; ++i) {
            int n = this.pixels[i];
            int n2 = n & 0xFF0000;
            int n3 = n & 0xFF00;
            int n4 = n & 0xFF;
            n2 = n2 + (n2 << 1) >> 2;
            n3 = n3 + (n3 << 1) >> 2;
            n4 = n4 + (n4 << 1) >> 2;
            this.pixels[i] = (n2 &= 0xFF0000) | (n3 &= 0xFF00) | (n4 &= 0xFF) | 0xFF000000;
            this.zbuffer[i] = -2147483647;
        }
    }

    private void checkListeners() {
        int n;
        if (this.usedBy == null) {
            this.usedBy = new Vector(2);
        }
        Vector<VisListManager> vector = null;
        for (n = 0; n < this.usedBy.size(); ++n) {
            VisListManager visListManager = (VisListManager)this.usedBy.get(n);
            if (!visListManager.isDisposed) continue;
            if (vector == null) {
                vector = new Vector<VisListManager>();
            }
            vector.addElement(visListManager);
        }
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                this.usedBy.removeElement(vector.get(n));
            }
        }
    }

    private void removeListeners() {
        try {
            for (int i = 0; i < this.usedBy.size(); ++i) {
                VisListManager visListManager = (VisListManager)this.usedBy.elementAt(i);
                visListManager.remove(this);
            }
        }
        catch (Exception exception) {
            Logger.log("Couldn't unregister visibility list!", 1);
        }
    }

    protected void finalize() {
        this.checkListeners();
        this.removeListeners();
    }

    static {
        try {
            Toolkit.getDefaultToolkit();
            Class.forName("org.lwjgl.opengl.JOGLPresent").newInstance();
            useJOGL = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SYNCHRONIZER = new Object();
        sid = 0L;
    }

    private static final class Drawer
    implements WorkLoad {
        private Image image = null;
        private int ys = 0;
        private int ye = 0;
        private int width = 0;
        private Graphics g = null;
        private int yoffset = 0;
        private int xoffset = 0;

        public Drawer(Image image, int n, int n2, int n3) {
            this.image = image;
            this.ys = n;
            this.ye = n2;
            this.width = n3;
        }

        public void set(Graphics graphics, int n, int n2) {
            this.g = graphics;
            this.yoffset = n;
            this.xoffset = n2;
        }

        public void doWork() {
            this.g.drawImage(this.image, this.xoffset, this.yoffset + this.ys, this.width + this.xoffset, this.ye + this.yoffset, 0, this.ys, this.width, this.ye, null);
        }

        public void done() {
        }

        public void error(Exception exception) {
        }
    }

    private class ClearyLoad
    implements WorkLoad {
        private boolean z = false;
        private int div = 0;
        private int color = 0;
        private boolean zOnly = false;

        private ClearyLoad() {
        }

        public void setMode(boolean bl) {
            this.z = bl;
        }

        public void setSection(int n) {
            this.div = n;
        }

        public void doWork() {
            int[] nArray = FrameBuffer.this.zbuffer;
            int[] nArray2 = FrameBuffer.this.pixels;
            int n = nArray.length / FrameBuffer.this.clearLoads.length;
            int n2 = n * this.div;
            int n3 = n2 + n;
            if (this.z) {
                if (!this.zOnly) {
                    for (int i = n2; i < n3; ++i) {
                        nArray[i] = -2147483647;
                        nArray2[i] = this.color;
                    }
                } else {
                    for (int i = n2; i < n3; ++i) {
                        nArray[i] = -2147483647;
                    }
                }
            } else {
                FrameBuffer.this.oversample(this.div);
            }
        }

        public void done() {
        }

        public void error(Exception exception) {
        }

        public void setColor(int n, boolean bl) {
            this.color = n;
            this.zOnly = bl;
        }
    }
}

