/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import java.io.Serializable;

public final class Animation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LINEAR = 0;
    public static final int COSINE = 1;
    public static final int BICUBIC = 2;
    public static final int HERMITE = 3;
    public static final int KEYFRAMESONLY = 4;
    public static final int USE_WRAPPING = 0;
    public static final int USE_CLAMPING = 1;
    int aktFrames;
    Mesh[] keyFrames;
    int endFrame;
    int maxFrames;
    int mode;
    float hermiteBias;
    float hermiteTension;
    int[] startFrames;
    int[] endFrames;
    String[] seqNames;
    int anzAnim;
    int wrapMode;

    public Animation(int n) {
        this.maxFrames = n;
        this.keyFrames = new Mesh[n];
        this.endFrame = 0;
        this.aktFrames = 0;
        this.hermiteBias = 0.0f;
        this.hermiteTension = 0.0f;
        this.mode = 0;
        this.anzAnim = 0;
        this.wrapMode = 0;
        this.startFrames = new int[Config.maxAnimationSubSequences];
        this.endFrames = new int[Config.maxAnimationSubSequences];
        this.seqNames = new String[Config.maxAnimationSubSequences];
        for (int i = 0; i < Config.maxAnimationSubSequences; ++i) {
            this.startFrames[i] = -1;
            this.endFrames[i] = -1;
            this.seqNames[i] = null;
        }
    }

    public void strip() {
        for (int i = 0; i < this.aktFrames; ++i) {
            if (this.keyFrames[i] == null) continue;
            this.keyFrames[i].strip();
        }
    }

    public void remove(int n) {
        int[] nArray = this.getSequenceBorders(n);
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            this.keyFrames[i] = null;
        }
    }

    public String getName(int n) {
        return this.seqNames[n];
    }

    public int[] getSequenceBorders(int n) {
        return new int[]{this.startFrames[n], this.endFrames[n]};
    }

    public int getSequence(String string) {
        int n = this.seqNames.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(this.seqNames[i])) continue;
            return i;
        }
        return -1;
    }

    public Mesh[] getKeyFrames() {
        Mesh[] meshArray = new Mesh[this.aktFrames];
        System.arraycopy(this.keyFrames, 0, meshArray, 0, this.aktFrames);
        return meshArray;
    }

    public int createSubSequence(String string) {
        if (this.anzAnim + 1 < Config.maxAnimationSubSequences) {
            ++this.anzAnim;
            this.startFrames[this.anzAnim] = this.aktFrames;
            this.seqNames[this.anzAnim] = string;
            this.startFrames[0] = 0;
            this.endFrames[0] = 0;
            this.seqNames[0] = "complete";
        } else {
            Logger.log("Too many sub-sequences defined. Modify configuration to allow a higher number.", 0);
        }
        return this.anzAnim;
    }

    public int getSequenceCount() {
        return this.anzAnim;
    }

    public void setClampingMode(int n) {
        if (n != 0 && n != 1) {
            Logger.log("Clamping-mode not supported!", 0);
        } else {
            this.wrapMode = n;
        }
    }

    public void addKeyFrame(Mesh mesh) {
        if (this.anzAnim == 0) {
            Logger.log("Can't add a keyframe without a sub-sequence being created!", 0);
        } else if (mesh.obbStart != 0) {
            if (this.aktFrames < this.maxFrames) {
                this.keyFrames[this.aktFrames] = mesh;
                this.endFrames[this.anzAnim] = ++this.aktFrames;
                this.endFrame = this.aktFrames;
            } else {
                Logger.log("Too many keyframes defined!", 0);
            }
        } else {
            Logger.log("Bounding box missing in this mesh!", 0);
        }
        this.endFrames[0] = this.endFrame;
    }

    public void setInterpolationMethod(int n) {
        this.mode = n;
    }

    public void setHermiteParameter(float f, float f2) {
        this.hermiteBias = f;
        this.hermiteTension = f2;
    }

    void rotateMesh(Matrix matrix, float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.aktFrames; ++i) {
            if (this.keyFrames[i] == null) continue;
            this.keyFrames[i].rotateMesh(matrix, f, f2, f3, f4);
        }
    }

    void translateMesh(Matrix matrix, Matrix matrix2) {
        for (int i = 0; i < this.aktFrames; ++i) {
            if (this.keyFrames[i] == null) continue;
            this.keyFrames[i].translateMesh(matrix, matrix2);
        }
    }

    void doAnimation(Object3D object3D, int n, float f) {
        if (n <= this.anzAnim) {
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            int n2 = this.endFrames[n];
            int n3 = this.startFrames[n];
            float f2 = f * (float)(n2 - n3 - this.wrapMode) + (float)n3;
            if (this.wrapMode == 1) {
                if (f2 >= (float)n2) {
                    f2 = n2 - 1;
                } else if (f2 < (float)n3) {
                    f2 = n3;
                }
            }
            int n4 = (int)f2;
            float f3 = f2 - (float)n4;
            switch (this.mode) {
                case 0: {
                    this.interpolateLinear(object3D, n4, f3, n3, n2);
                    break;
                }
                case 1: {
                    this.interpolateCosine(object3D, n4, f3, n3, n2);
                    break;
                }
                case 2: {
                    this.interpolateBiCubic(object3D, n4, f3, n3, n2);
                    break;
                }
                case 3: {
                    this.interpolateHermite(object3D, n4, f3, n3, n2);
                    break;
                }
                case 4: {
                    this.interpolateNone(object3D, n4, n3, n2);
                    break;
                }
                default: {
                    Logger.log("Unsupported interpolation mode used!", 0);
                    break;
                }
            }
        } else {
            Logger.log("Sub-sequence number " + n + " doesn't exist!", 0);
        }
    }

    void interpolateHermite(Object3D object3D, int n, float f, int n2, int n3) {
        int n4 = n - 1;
        int n5 = n;
        int n6 = n + 1;
        int n7 = n + 2;
        if (this.wrapMode == 1) {
            if (n7 >= n3) {
                n7 = n3 - 1;
            } else if (n7 < n2) {
                n7 = n2;
            }
            if (n4 >= n3) {
                n4 = n3 - 1;
            } else if (n4 < n2) {
                n4 = n2;
            }
            if (n5 >= n3) {
                n5 = n3 - 1;
            } else if (n5 < n2) {
                n5 = n2;
            }
            if (n6 >= n3) {
                n6 = n3 - 1;
            } else if (n6 < n2) {
                n6 = n2;
            }
        } else {
            if (n7 >= n3) {
                n7 = n2 + 1;
            } else if (n7 < n2) {
                n7 = n3 - 1;
            }
            if (n4 >= n3) {
                n4 = n2;
            } else if (n4 < n2) {
                n4 = n3 - 2;
            }
            if (n5 >= n3) {
                n5 = n2;
            } else if (n5 < n2) {
                n5 = n3 - 1;
            }
            if (n6 >= n3) {
                n6 = n2;
            } else if (n6 < n2) {
                n6 = n3 - 1;
            }
        }
        float f2 = f * f;
        float f3 = f2 * f;
        int n8 = object3D.objMesh.anzCoords;
        for (int i = 0; i < n8; ++i) {
            float f4 = (this.keyFrames[n5].xOrg[i] - this.keyFrames[n4].xOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f4 += (this.keyFrames[n6].xOrg[i] - this.keyFrames[n5].xOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            float f5 = (this.keyFrames[n6].xOrg[i] - this.keyFrames[n5].xOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            float f6 = 2.0f * f3 - 3.0f * f2 + 1.0f;
            float f7 = f3 - 2.0f * f2 + f;
            float f8 = f3 - f2;
            float f9 = -2.0f * f3 + 3.0f * f2;
            object3D.objMesh.xOrg[i] = f6 * this.keyFrames[n5].xOrg[i] + f7 * f4 + f8 * (f5 += (this.keyFrames[n7].xOrg[i] - this.keyFrames[n6].xOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f) + f9 * this.keyFrames[n6].xOrg[i];
            f4 = (this.keyFrames[n5].yOrg[i] - this.keyFrames[n4].yOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f4 += (this.keyFrames[n6].yOrg[i] - this.keyFrames[n5].yOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f5 = (this.keyFrames[n6].yOrg[i] - this.keyFrames[n5].yOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f6 = 2.0f * f3 - 3.0f * f2 + 1.0f;
            f7 = f3 - 2.0f * f2 + f;
            f8 = f3 - f2;
            f9 = -2.0f * f3 + 3.0f * f2;
            object3D.objMesh.yOrg[i] = f6 * this.keyFrames[n5].yOrg[i] + f7 * f4 + f8 * (f5 += (this.keyFrames[n7].yOrg[i] - this.keyFrames[n6].yOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f) + f9 * this.keyFrames[n6].yOrg[i];
            f4 = (this.keyFrames[n5].zOrg[i] - this.keyFrames[n4].zOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f4 += (this.keyFrames[n6].zOrg[i] - this.keyFrames[n5].zOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f5 = (this.keyFrames[n6].zOrg[i] - this.keyFrames[n5].zOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f6 = 2.0f * f3 - 3.0f * f2 + 1.0f;
            f7 = f3 - 2.0f * f2 + f;
            f8 = f3 - f2;
            f9 = -2.0f * f3 + 3.0f * f2;
            object3D.objMesh.zOrg[i] = f6 * this.keyFrames[n5].zOrg[i] + f7 * f4 + f8 * (f5 += (this.keyFrames[n7].zOrg[i] - this.keyFrames[n6].zOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f) + f9 * this.keyFrames[n6].zOrg[i];
            f4 = (this.keyFrames[n5].nxOrg[i] - this.keyFrames[n4].nxOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f4 += (this.keyFrames[n6].nxOrg[i] - this.keyFrames[n5].nxOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f5 = (this.keyFrames[n6].nxOrg[i] - this.keyFrames[n5].nxOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f6 = 2.0f * f3 - 3.0f * f2 + 1.0f;
            f7 = f3 - 2.0f * f2 + f;
            f8 = f3 - f2;
            f9 = -2.0f * f3 + 3.0f * f2;
            object3D.objMesh.nxOrg[i] = f6 * this.keyFrames[n5].nxOrg[i] + f7 * f4 + f8 * (f5 += (this.keyFrames[n7].nxOrg[i] - this.keyFrames[n6].nxOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f) + f9 * this.keyFrames[n6].nxOrg[i];
            f4 = (this.keyFrames[n5].nyOrg[i] - this.keyFrames[n4].nyOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f4 += (this.keyFrames[n6].nyOrg[i] - this.keyFrames[n5].nyOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f5 = (this.keyFrames[n6].nyOrg[i] - this.keyFrames[n5].nyOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f6 = 2.0f * f3 - 3.0f * f2 + 1.0f;
            f7 = f3 - 2.0f * f2 + f;
            f8 = f3 - f2;
            f9 = -2.0f * f3 + 3.0f * f2;
            object3D.objMesh.nyOrg[i] = f6 * this.keyFrames[n5].nyOrg[i] + f7 * f4 + f8 * (f5 += (this.keyFrames[n7].nyOrg[i] - this.keyFrames[n6].nyOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f) + f9 * this.keyFrames[n6].nyOrg[i];
            f4 = (this.keyFrames[n5].nzOrg[i] - this.keyFrames[n4].nzOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f4 += (this.keyFrames[n6].nzOrg[i] - this.keyFrames[n5].nzOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f5 = (this.keyFrames[n6].nzOrg[i] - this.keyFrames[n5].nzOrg[i]) * (1.0f + this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f;
            f6 = 2.0f * f3 - 3.0f * f2 + 1.0f;
            f7 = f3 - 2.0f * f2 + f;
            f8 = f3 - f2;
            f9 = -2.0f * f3 + 3.0f * f2;
            object3D.objMesh.nzOrg[i] = f6 * this.keyFrames[n5].nzOrg[i] + f7 * f4 + f8 * (f5 += (this.keyFrames[n7].nzOrg[i] - this.keyFrames[n6].nzOrg[i]) * (1.0f - this.hermiteBias) * (1.0f - this.hermiteTension) / 2.0f) + f9 * this.keyFrames[n6].nzOrg[i];
        }
    }

    void interpolateBiCubic(Object3D object3D, int n, float f, int n2, int n3) {
        int n4 = n - 1;
        int n5 = n;
        int n6 = n + 1;
        int n7 = n + 2;
        if (this.wrapMode == 1) {
            if (n7 >= n3) {
                n7 = n3 - 1;
            } else if (n7 < n2) {
                n7 = n2;
            }
            if (n4 >= n3) {
                n4 = n3 - 1;
            } else if (n4 < n2) {
                n4 = n2;
            }
            if (n5 >= n3) {
                n5 = n3 - 1;
            } else if (n5 < n2) {
                n5 = n2;
            }
            if (n6 >= n3) {
                n6 = n3 - 1;
            } else if (n6 < n2) {
                n6 = n2;
            }
        } else {
            if (n7 >= n3) {
                n7 = n2 + 1;
            } else if (n7 < n2) {
                n7 = n3 - 1;
            }
            if (n4 >= n3) {
                n4 = n2;
            } else if (n4 < n2) {
                n4 = n3 - 2;
            }
            if (n5 >= n3) {
                n5 = n2;
            } else if (n5 < n2) {
                n5 = n3 - 1;
            }
            if (n6 >= n3) {
                n6 = n2;
            } else if (n6 < n2) {
                n6 = n3 - 1;
            }
        }
        float f2 = f * f;
        int n8 = object3D.objMesh.anzCoords;
        for (int i = 0; i < n8; ++i) {
            float f3 = this.keyFrames[n7].xOrg[i] - this.keyFrames[n6].xOrg[i] - this.keyFrames[n4].xOrg[i] + this.keyFrames[n5].xOrg[i];
            float f4 = this.keyFrames[n4].xOrg[i] - this.keyFrames[n5].xOrg[i] - f3;
            float f5 = this.keyFrames[n6].xOrg[i] - this.keyFrames[n4].xOrg[i];
            float f6 = this.keyFrames[n5].xOrg[i];
            object3D.objMesh.xOrg[i] = f3 * f * f2 + f4 * f2 + f5 * f + f6;
            f3 = this.keyFrames[n7].yOrg[i] - this.keyFrames[n6].yOrg[i] - this.keyFrames[n4].yOrg[i] + this.keyFrames[n5].yOrg[i];
            f4 = this.keyFrames[n4].yOrg[i] - this.keyFrames[n5].yOrg[i] - f3;
            f5 = this.keyFrames[n6].yOrg[i] - this.keyFrames[n4].yOrg[i];
            f6 = this.keyFrames[n5].yOrg[i];
            object3D.objMesh.yOrg[i] = f3 * f * f2 + f4 * f2 + f5 * f + f6;
            f3 = this.keyFrames[n7].zOrg[i] - this.keyFrames[n6].zOrg[i] - this.keyFrames[n4].zOrg[i] + this.keyFrames[n5].zOrg[i];
            f4 = this.keyFrames[n4].zOrg[i] - this.keyFrames[n5].zOrg[i] - f3;
            f5 = this.keyFrames[n6].zOrg[i] - this.keyFrames[n4].zOrg[i];
            f6 = this.keyFrames[n5].zOrg[i];
            object3D.objMesh.zOrg[i] = f3 * f * f2 + f4 * f2 + f5 * f + f6;
            f3 = this.keyFrames[n7].nxOrg[i] - this.keyFrames[n6].nxOrg[i] - this.keyFrames[n4].nxOrg[i] + this.keyFrames[n5].nxOrg[i];
            f4 = this.keyFrames[n4].nxOrg[i] - this.keyFrames[n5].nxOrg[i] - f3;
            f5 = this.keyFrames[n6].nxOrg[i] - this.keyFrames[n4].nxOrg[i];
            f6 = this.keyFrames[n5].nxOrg[i];
            object3D.objMesh.nxOrg[i] = f3 * f * f2 + f4 * f2 + f5 * f + f6;
            f3 = this.keyFrames[n7].nyOrg[i] - this.keyFrames[n6].nyOrg[i] - this.keyFrames[n4].nyOrg[i] + this.keyFrames[n5].nyOrg[i];
            f4 = this.keyFrames[n4].nyOrg[i] - this.keyFrames[n5].nyOrg[i] - f3;
            f5 = this.keyFrames[n6].nyOrg[i] - this.keyFrames[n4].nyOrg[i];
            f6 = this.keyFrames[n5].nyOrg[i];
            object3D.objMesh.nyOrg[i] = f3 * f * f2 + f4 * f2 + f5 * f + f6;
            f3 = this.keyFrames[n7].nzOrg[i] - this.keyFrames[n6].nzOrg[i] - this.keyFrames[n4].nzOrg[i] + this.keyFrames[n5].nzOrg[i];
            f4 = this.keyFrames[n4].nzOrg[i] - this.keyFrames[n5].nzOrg[i] - f3;
            f5 = this.keyFrames[n6].nzOrg[i] - this.keyFrames[n4].nzOrg[i];
            f6 = this.keyFrames[n5].nzOrg[i];
            object3D.objMesh.nzOrg[i] = f3 * f * f2 + f4 * f2 + f5 * f + f6;
        }
    }

    void interpolateLinear(Object3D object3D, int n, float f, int n2, int n3) {
        float f2 = 1.0f - f;
        float f3 = f;
        int n4 = n;
        int n5 = n + 1;
        if (this.wrapMode == 1) {
            if (n5 >= n3) {
                n5 = n3 - 1;
            } else if (n5 < n2) {
                n5 = n2;
            }
            if (n4 >= n3) {
                n4 = n3 - 1;
            } else if (n4 < n2) {
                n4 = n2;
            }
        } else {
            if (n5 >= n3) {
                n5 = n2;
            } else if (n5 < n2) {
                n5 = n3 - 1;
            }
            if (n4 >= n3) {
                n4 = n2;
            } else if (n4 < n2) {
                n4 = n3 - 1;
            }
        }
        int n6 = object3D.objMesh.anzCoords;
        for (int i = 0; i < n6; ++i) {
            object3D.objMesh.xOrg[i] = this.keyFrames[n4].xOrg[i] * f2 + this.keyFrames[n5].xOrg[i] * f3;
            object3D.objMesh.yOrg[i] = this.keyFrames[n4].yOrg[i] * f2 + this.keyFrames[n5].yOrg[i] * f3;
            object3D.objMesh.zOrg[i] = this.keyFrames[n4].zOrg[i] * f2 + this.keyFrames[n5].zOrg[i] * f3;
            object3D.objMesh.nxOrg[i] = this.keyFrames[n4].nxOrg[i] * f2 + this.keyFrames[n5].nxOrg[i] * f3;
            object3D.objMesh.nyOrg[i] = this.keyFrames[n4].nyOrg[i] * f2 + this.keyFrames[n5].nyOrg[i] * f3;
            object3D.objMesh.nzOrg[i] = this.keyFrames[n4].nzOrg[i] * f2 + this.keyFrames[n5].nzOrg[i] * f3;
        }
    }

    void interpolateNone(Object3D object3D, int n, int n2, int n3) {
        int n4 = n;
        if (this.wrapMode == 1) {
            if (n4 >= n3) {
                n4 = n3 - 1;
            } else if (n4 < n2) {
                n4 = n2;
            }
        } else if (n4 >= n3) {
            n4 = n2;
        } else if (n4 < n2) {
            n4 = n3 - 1;
        }
        int n5 = object3D.objMesh.anzCoords;
        for (int i = 0; i < n5; ++i) {
            object3D.objMesh.xOrg[i] = this.keyFrames[n4].xOrg[i];
            object3D.objMesh.yOrg[i] = this.keyFrames[n4].yOrg[i];
            object3D.objMesh.zOrg[i] = this.keyFrames[n4].zOrg[i];
        }
    }

    void interpolateCosine(Object3D object3D, int n, float f, int n2, int n3) {
        float f2 = (1.0f - (float)Math.cos((double)f * Math.PI)) / 2.0f;
        float f3 = 1.0f - f2;
        int n4 = n;
        int n5 = n + 1;
        if (this.wrapMode == 1) {
            if (n5 >= n3) {
                n5 = n3 - 1;
            } else if (n5 < n2) {
                n5 = n2;
            }
            if (n4 >= n3) {
                n4 = n3 - 1;
            } else if (n4 < n2) {
                n4 = n2;
            }
        } else {
            if (n5 >= n3) {
                n5 = n2;
            } else if (n5 < n2) {
                n5 = n3 - 1;
            }
            if (n4 >= n3) {
                n4 = n2;
            } else if (n4 < n2) {
                n4 = n3 - 1;
            }
        }
        int n6 = object3D.objMesh.anzCoords;
        for (int i = 0; i < n6; ++i) {
            object3D.objMesh.xOrg[i] = this.keyFrames[n4].xOrg[i] * f3 + this.keyFrames[n5].xOrg[i] * f2;
            object3D.objMesh.yOrg[i] = this.keyFrames[n4].yOrg[i] * f3 + this.keyFrames[n5].yOrg[i] * f2;
            object3D.objMesh.zOrg[i] = this.keyFrames[n4].zOrg[i] * f3 + this.keyFrames[n5].zOrg[i] * f2;
            object3D.objMesh.nxOrg[i] = this.keyFrames[n4].nxOrg[i] * f3 + this.keyFrames[n5].nxOrg[i] * f2;
            object3D.objMesh.nyOrg[i] = this.keyFrames[n4].nyOrg[i] * f3 + this.keyFrames[n5].nyOrg[i] * f2;
            object3D.objMesh.nzOrg[i] = this.keyFrames[n4].nzOrg[i] * f3 + this.keyFrames[n5].nzOrg[i] * f2;
        }
    }

    void validate(Object3D object3D) {
        Mesh mesh = object3D.getMesh();
        if (mesh == null) {
            return;
        }
        for (int i = 0; i < this.aktFrames; ++i) {
            Mesh mesh2 = this.keyFrames[i];
            if (mesh2 == null || mesh2 != mesh) continue;
            Logger.log("The animation shares a mesh with the animated object...correcting...!", 1);
            this.keyFrames[i] = mesh2.cloneMesh(true);
        }
    }
}

