/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.AWTBufferList;
import com.threed.jpct.AWTDisplayList;
import com.threed.jpct.AWTJPCTCanvas;
import com.threed.jpct.Camera;
import com.threed.jpct.CompiledInstance;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GLBase;
import com.threed.jpct.GLHelper;
import com.threed.jpct.GLThreadBuffer;
import com.threed.jpct.IPostProcessor;
import com.threed.jpct.IRenderer;
import com.threed.jpct.IThreadBuffer;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.Projector;
import com.threed.jpct.Texture;
import com.threed.jpct.VisList;
import com.threed.jpct.World;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public class AWTGLRenderer
extends GLBase
implements IRenderer {
    protected IThreadBuffer canvas = null;
    private boolean realCanvas = true;
    private boolean forceFOV = false;
    private boolean aboutToDispose = false;
    private Camera cam = new Camera();
    private int[] ambient = new int[3];

    AWTGLRenderer() {
    }

    public Object getLock() {
        if (this.canvas != null) {
            return this.canvas.getLock();
        }
        return null;
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        this.init = false;
        try {
            if (this.realCanvas) {
                DisplayMode displayMode;
                PixelFormat pixelFormat = GLHelper.getPixelFormatFromConfig();
                if (pixelFormat == null && n5 > 0 && (displayMode = GLHelper.findMode(n, n2, n3, n4, true)) != null) {
                    try {
                        pixelFormat = new PixelFormat(displayMode.getBitsPerPixel(), 0, n4, 0, n5);
                    }
                    catch (Exception exception) {
                        Logger.log("Number of samples not supported or incorrect video mode!", 1);
                        n5 = 0;
                    }
                }
                if (pixelFormat == null) {
                    try {
                        this.canvas = new AWTJPCTCanvas(this, new PixelFormat(n3, 0, n4, 0, n5));
                    }
                    catch (Exception exception) {
                        Logger.log("Can't set video mode - using default instead!", 1);
                        this.canvas = new AWTJPCTCanvas(this);
                    }
                } else {
                    this.canvas = new AWTJPCTCanvas(this, pixelFormat);
                }
            } else {
                this.canvas = new GLThreadBuffer(this);
            }
            this.canvas.setBounds(0, 0, n, n2);
            this.canvas.setSamples(n5);
            this.xp = n;
            this.yp = n2;
        }
        catch (Exception exception) {
            Logger.log("Can't initialize canvas!", 0);
            exception.printStackTrace();
        }
    }

    public void dispose() {
        this.aboutToDispose = true;
    }

    private void reallyDispose() {
        this.aboutToDispose = false;
        super.dispose();
        this.canvas.dispose();
        Logger.log("OpenGL (AWTGLCanvas) renderer disposed", 2);
    }

    Object[] executeGL(AWTDisplayList aWTDisplayList, int n) {
        if (this.init) {
            int n2 = aWTDisplayList.command[n];
            Object[] objectArray = (Object[])aWTDisplayList.params[n];
            if (n2 == 4 || n2 == 7) {
                this.enableBlitting(objectArray);
            } else {
                this.disableBlitting();
            }
            switch (n2) {
                case 23: {
                    this.reInit();
                    break;
                }
                case 0: {
                    this.myWorld = (World)objectArray[0];
                    this.setFrustum(objectArray);
                    this.setLightsAndFog(this.myWorld);
                    this.unloadTextures();
                    this.removeListsAndBuffers();
                    break;
                }
                case 2: {
                    this.clear(objectArray);
                    break;
                }
                case 4: {
                    this.blit(objectArray, this.scaleX, this.scaleY);
                    break;
                }
                case 5: {
                    GL11.glFlush();
                    break;
                }
                case 6: {
                    this.grabScreen(objectArray);
                    return objectArray;
                }
                case 7: {
                    this.prepareForBlitting(objectArray);
                    Object[] objectArray2 = new Object[objectArray.length];
                    System.arraycopy(objectArray, 1, objectArray2, 1, objectArray2.length - 1);
                    objectArray2[0] = this.blitBuffer;
                    this.blit(objectArray2, this.scaleX, this.scaleY);
                    break;
                }
                case 8: {
                    this.endState();
                    break;
                }
                case 9: {
                    this.setBufferViewport(objectArray);
                    break;
                }
                case 10: {
                    if (objectArray[0] instanceof String) {
                        objectArray[0] = Config.booleanValueOf(this.supportsExtension((String)objectArray[0]));
                    }
                    return objectArray;
                }
                case 26: {
                    float[] fArray = (float[])objectArray[1];
                    Integer n3 = (Integer)objectArray[0];
                    this.addClippingPlane(n3, fArray);
                    break;
                }
                case 27: {
                    Integer n4 = (Integer)objectArray[0];
                    this.removeClippingPlane(n4);
                    break;
                }
                case 25: {
                    if (objectArray[0] instanceof String) {
                        objectArray[0] = IntegerC.valueOf(this.getTextureSize());
                    }
                    return objectArray;
                }
                case 15: {
                    this.clearZBufferOnly();
                    break;
                }
                case 16: {
                    this.doPostProcessing(objectArray);
                    break;
                }
                case 17: {
                    IPostProcessor iPostProcessor = (IPostProcessor)objectArray[1];
                    iPostProcessor.dispose();
                    break;
                }
                case 18: {
                    this.setRenderTarget(objectArray);
                    break;
                }
                case 1000: {
                    this.renderToTarget();
                    break;
                }
                case 21: {
                    this.cam = (Camera)objectArray[0];
                    this.ambient = (int[])objectArray[1];
                    break;
                }
                case 22: {
                    this.setTextureProjector((Projector)objectArray[0], (Texture)objectArray[1]);
                    break;
                }
                case 24: {
                    this.listenerActive = (Boolean)objectArray[0];
                }
            }
        }
        return null;
    }

    public void execute(int n, Object[] objectArray) {
        switch (n) {
            case 0: {
                this.canvas.add(n, this.createFrustum(objectArray));
                break;
            }
            case 23: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 1: {
                this.bufferTextureProjectors();
                if (!this.canvas.hasRenderTarget()) {
                    this.canvas.switchList();
                    Thread.yield();
                    break;
                }
                this.canvas.add(1000, null);
                break;
            }
            case 2: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 3: {
                Logger.log("State changes: " + this.stateChanges, 2);
                this.stateChanges = 0;
                break;
            }
            case 4: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 5: {
                this.canvas.add(n, null);
                break;
            }
            case 6: {
                this.canvas.addOnce(n, objectArray);
                this.waitForPainting(objectArray);
                break;
            }
            case 7: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 26: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 27: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 8: {
                this.canvas.add(n, null);
                break;
            }
            case 9: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 10: {
                this.canvas.addOnce(n, objectArray);
                this.waitForPainting(objectArray);
                break;
            }
            case 25: {
                this.canvas.addOnce(n, objectArray);
                this.waitForPainting(objectArray);
                break;
            }
            case 11: {
                objectArray[0] = this.canvas;
                break;
            }
            case 12: {
                if (this.listener == null || !this.listenerActive) break;
                this.listener.startPainting();
                break;
            }
            case 13: {
                this.endState();
                this.resetTextureStates();
                if (this.listener != null && this.listenerActive) {
                    this.listener.finishedPainting();
                }
                if (!this.aboutToDispose) break;
                this.reallyDispose();
                break;
            }
            case 14: {
                this.realCanvas = (Boolean)objectArray[0];
                break;
            }
            case 15: {
                this.canvas.add(n, null);
                break;
            }
            case 16: {
                this.canvas.add(n, objectArray);
                break;
            }
            case 17: {
                this.canvas.addOnce(n, objectArray);
                this.waitForPainting(objectArray);
                break;
            }
            case 18: {
                this.forceFOV = true;
                if (objectArray[0] == null) {
                    this.canvas.disableRenderTarget();
                } else {
                    this.canvas.enableRenderTarget();
                }
                this.canvas.add(n, objectArray);
                break;
            }
            case 24: {
                this.canvas.add(n, objectArray);
            }
        }
    }

    void init() throws Exception {
        this.init(true, this.xp, this.yp);
    }

    protected void enableBlitting(Object[] objectArray) {
        if (this.myWorld == null) {
            this.myWorld = new World();
            FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
            int n = frameBuffer.getOutputWidth();
            int n2 = frameBuffer.getOutputHeight();
            this.myWorld.getCamera().calcFOV(n, n2);
            Object[] objectArray2 = new Object[]{this.myWorld, frameBuffer};
            objectArray2 = this.createFrustum(objectArray2);
            this.setFrustum(objectArray2);
        }
        super.enableBlitting(objectArray);
    }

    private void waitForPainting(Object[] objectArray) {
        if (this.canvas.isVisible()) {
            this.canvas.observePainting();
            this.canvas.repaint();
            while (!this.canvas.hasBeenPainted()) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
            Object[] objectArray2 = this.canvas.getPaintResults();
            if (objectArray2 != null && objectArray2.length >= objectArray.length) {
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
            }
        } else {
            objectArray[0] = null;
            Logger.log("Unable to get gl context, canvas not visible!", 0);
        }
    }

    private Object[] createFrustum(Object[] objectArray) {
        World world = (World)objectArray[0];
        Camera camera = world.getCamera();
        float f = camera.getFOV();
        FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
        this.canvas.add(camera, world.getAmbientLight());
        if (this.forceFOV || f != this.lastFOV || Config.farPlane != this.lastFarPlane || !Config.glIgnoreNearPlane && Config.nearPlane != this.lastNearPlane || Config.autoMaintainAspectRatio != this.lastFOVMode) {
            this.forceFOV = false;
            float f2 = 0.0f;
            objectArray = new Object[11];
            float f3 = frameBuffer.getOutputHeight();
            float f4 = frameBuffer.getOutputWidth();
            if (frameBuffer.renderTarget != null) {
                f3 = frameBuffer.renderTarget.height;
                f4 = frameBuffer.renderTarget.height;
            }
            f2 = Config.autoMaintainAspectRatio ? f * (f3 / f4) : f;
            if (camera.getYFOV() != -1.0f) {
                f2 = camera.getYFOV();
            }
            float f5 = Config.farPlane;
            float f6 = 1.0f;
            if (!Config.glIgnoreNearPlane) {
                f6 = Config.nearPlane;
            }
            float f7 = f2 * 0.5f;
            float f8 = -f2 * 0.5f;
            float f9 = -f * 0.5f;
            float f10 = f * 0.5f;
            objectArray[1] = new Float(f9);
            objectArray[2] = new Float(f10);
            objectArray[3] = new Float(f8);
            objectArray[4] = new Float(f7);
            objectArray[5] = new Float(f6);
            objectArray[6] = new Float(f5);
            objectArray[7] = new Float(f + 100.0f * f2);
            objectArray[8] = new Float(camera.scaleX);
            objectArray[9] = new Float(camera.scaleY);
            objectArray[10] = Config.autoMaintainAspectRatio;
            objectArray[0] = world;
        }
        return objectArray;
    }

    private void setFrustum(Object[] objectArray) {
        if (objectArray.length != 2) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glFrustum((double)((Float)objectArray[1]).floatValue(), (double)((Float)objectArray[2]).floatValue(), (double)((Float)objectArray[3]).floatValue(), (double)((Float)objectArray[4]).floatValue(), (double)((Float)objectArray[5]).floatValue(), (double)((Float)objectArray[6]).floatValue());
            this.lastFOV = ((Float)objectArray[7]).floatValue();
            this.lastFarPlane = ((Float)objectArray[6]).floatValue();
            this.lastNearPlane = ((Float)objectArray[5]).floatValue();
            this.lastFOVMode = (Boolean)objectArray[10];
            this.setScale(((Float)objectArray[8]).floatValue(), ((Float)objectArray[9]).floatValue());
        }
    }

    public void drawStrip(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        if (this.init) {
            this.canvas.add(visList, n, n2, 1);
        }
    }

    void drawStrip(AWTDisplayList aWTDisplayList, int n) {
        if (this.init) {
            int n2;
            float f;
            float f2;
            this.endState();
            AWTBufferList aWTBufferList = aWTDisplayList.vl[n].getFrontBuffer();
            int n3 = aWTDisplayList.start[n];
            int n4 = aWTDisplayList.end[n];
            Texture texture = this.setTextures(aWTBufferList, n3, this.cam, null);
            this.disableBlitting();
            boolean bl = texture.projector == null;
            int n5 = aWTBufferList.stageCnt[n3];
            int n6 = this.currentRGBScaling;
            float f3 = aWTBufferList.r1[n3];
            float f4 = aWTBufferList.g1[n3];
            float f5 = aWTBufferList.b1[n3];
            float f6 = 1.0f;
            float f7 = 1.0f;
            float f8 = 1.0f;
            boolean bl2 = aWTBufferList.trans[n3];
            boolean bl3 = aWTBufferList.multi[n3];
            int n7 = aWTBufferList.maxStages[n3];
            if (n7 > this.minDriverAndConfig) {
                n7 = this.minDriverAndConfig;
            }
            --n7;
            if (bl2) {
                this.setBlendingMode(aWTBufferList.transValue[n3] >> 16);
                if (n5 == 0) {
                    this.setDepthBuffer();
                }
                if (aWTBufferList.a1 == null || aWTBufferList.a1[n3] == -1.0f) {
                    f6 = Config.glTransparencyOffset + (float)(aWTBufferList.transValue[n3] & 0xFFFF) * Config.glTransparencyMul;
                    if (f6 > 1.0f) {
                        f6 = 1.0f;
                    }
                    f7 = f6;
                    f8 = f6;
                } else {
                    f6 = aWTBufferList.a1[n3];
                    f7 = aWTBufferList.a2[n3];
                    f8 = aWTBufferList.a3[n3];
                }
            }
            if (n5 > 0) {
                int n8 = aWTBufferList.multiMode[0][n3];
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)GLBase.blendSrcMap[n8], (int)GLBase.blendDstMap[n8]);
                if (n6 != 1) {
                    this.setRGBScaling(1);
                }
                GL11.glDepthMask((boolean)false);
                GL11.glDepthFunc((int)514);
            }
            GL11.glBegin((int)5);
            float f9 = aWTBufferList.x1[n3];
            float f10 = aWTBufferList.y1[n3];
            float f11 = aWTBufferList.z1[n3];
            float f12 = aWTBufferList.x2[n3];
            float f13 = aWTBufferList.y2[n3];
            float f14 = aWTBufferList.z2[n3];
            float f15 = aWTBufferList.x3[n3];
            float f16 = aWTBufferList.y3[n3];
            float f17 = aWTBufferList.z3[n3];
            if (bl) {
                f2 = aWTBufferList.u1[n3];
                f = aWTBufferList.v1[n3];
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl3) {
                for (n2 = 0; n2 < n7; ++n2) {
                    if (aWTBufferList.multiTextures[n2][n3] == null || aWTBufferList.multiTextures[n2][n3].projector != null) continue;
                    ARBMultitexture.glMultiTexCoord2fARB((int)GLBase.stageMap[n2 + 1], (float)aWTBufferList.u1Mul[n2][n3], (float)aWTBufferList.v1Mul[n2][n3]);
                }
            }
            GL11.glColor4f((float)(f3 * GLBase.COLOR_INV), (float)(f4 * GLBase.COLOR_INV), (float)(f5 * GLBase.COLOR_INV), (float)f6);
            GL11.glVertex3f((float)f9, (float)(-f10), (float)(-f11));
            f3 = aWTBufferList.r2[n3];
            f4 = aWTBufferList.g2[n3];
            f5 = aWTBufferList.b2[n3];
            if (bl) {
                f2 = aWTBufferList.u2[n3];
                f = aWTBufferList.v2[n3];
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl3) {
                for (n2 = 0; n2 < n7; ++n2) {
                    if (aWTBufferList.multiTextures[n2][n3] == null || aWTBufferList.multiTextures[n2][n3].projector != null) continue;
                    ARBMultitexture.glMultiTexCoord2fARB((int)GLBase.stageMap[n2 + 1], (float)aWTBufferList.u2Mul[n2][n3], (float)aWTBufferList.v2Mul[n2][n3]);
                }
            }
            GL11.glColor4f((float)(f3 * GLBase.COLOR_INV), (float)(f4 * GLBase.COLOR_INV), (float)(f5 * GLBase.COLOR_INV), (float)f7);
            GL11.glVertex3f((float)f12, (float)(-f13), (float)(-f14));
            f3 = aWTBufferList.r3[n3];
            f4 = aWTBufferList.g3[n3];
            f5 = aWTBufferList.b3[n3];
            if (bl) {
                f2 = aWTBufferList.u3[n3];
                f = aWTBufferList.v3[n3];
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl3) {
                for (n2 = 0; n2 < n7; ++n2) {
                    if (aWTBufferList.multiTextures[n2][n3] == null || aWTBufferList.multiTextures[n2][n3].projector != null) continue;
                    ARBMultitexture.glMultiTexCoord2fARB((int)GLBase.stageMap[n2 + 1], (float)aWTBufferList.u3Mul[n2][n3], (float)aWTBufferList.v3Mul[n2][n3]);
                }
            }
            GL11.glColor4f((float)(f3 * GLBase.COLOR_INV), (float)(f4 * GLBase.COLOR_INV), (float)(f5 * GLBase.COLOR_INV), (float)f8);
            GL11.glVertex3f((float)f15, (float)(-f16), (float)(-f17));
            n4 += ++n3;
            while (n3 < n4) {
                f3 = aWTBufferList.r3[n3];
                f4 = aWTBufferList.g3[n3];
                f5 = aWTBufferList.b3[n3];
                GL11.glTexCoord2f((float)aWTBufferList.u3[n3], (float)aWTBufferList.v3[n3]);
                if (bl3) {
                    for (n2 = 0; n2 < n7; ++n2) {
                        if (aWTBufferList.multiTextures[n2][n3] == null) continue;
                        ARBMultitexture.glMultiTexCoord2fARB((int)GLBase.stageMap[n2 + 1], (float)aWTBufferList.u3Mul[n2][n3], (float)aWTBufferList.v3Mul[n2][n3]);
                    }
                }
                if (aWTBufferList.a3 != null && aWTBufferList.a3[n3] != -1.0f) {
                    f6 = aWTBufferList.a3[n3];
                }
                GL11.glColor4f((float)(f3 * GLBase.COLOR_INV), (float)(f4 * GLBase.COLOR_INV), (float)(f5 * GLBase.COLOR_INV), (float)f6);
                GL11.glVertex3f((float)aWTBufferList.x3[n3], (float)(-aWTBufferList.y3[n3]), (float)(-aWTBufferList.z3[n3]));
                ++n3;
            }
            GL11.glEnd();
            if (bl2 || n5 > 0) {
                this.unsetBlendingMode();
                GL11.glDepthMask((boolean)true);
                if (n5 > 0) {
                    GL11.glDepthFunc((int)515);
                    if (n6 != 1) {
                        this.setRGBScaling(n6);
                    }
                }
            }
        }
    }

    public void drawPolygon(VisList visList, int n, FrameBuffer frameBuffer, World world) {
        if (this.init) {
            this.canvas.add(visList, n, n, 0);
        }
    }

    void drawPolygon(AWTDisplayList aWTDisplayList, int n) {
        if (this.init) {
            int n2;
            boolean bl;
            AWTBufferList aWTBufferList = aWTDisplayList.vl[n].getFrontBuffer();
            int n3 = aWTDisplayList.start[n];
            Texture texture = this.setTextures(aWTBufferList, n3, this.cam, null);
            this.disableBlitting();
            boolean bl2 = bl = texture.projector == null;
            if (texture == null) {
                Logger.log("Fatal error!", 0);
                return;
            }
            float f = 1.0f;
            float f2 = 1.0f;
            float f3 = 1.0f;
            int n4 = aWTBufferList.stageCnt[n3];
            boolean bl3 = aWTBufferList.trans[n3];
            boolean bl4 = aWTBufferList.multi[n3];
            int n5 = aWTBufferList.maxStages[n3];
            if (n5 > this.minDriverAndConfig) {
                n5 = this.minDriverAndConfig;
            }
            --n5;
            if (bl3) {
                this.endState();
                this.setBlendingMode(aWTBufferList.transValue[n3] >> 16);
                if (n4 == 0) {
                    this.setDepthBuffer();
                }
                if (aWTBufferList.a1 == null || aWTBufferList.a1[n3] == -1.0f) {
                    f = Config.glTransparencyOffset + (float)(aWTBufferList.transValue[n3] & 0xFFFF) * Config.glTransparencyMul;
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                    f2 = f;
                    f3 = f;
                } else {
                    f = aWTBufferList.a1[n3];
                    f2 = aWTBufferList.a2[n3];
                    f3 = aWTBufferList.a3[n3];
                }
            }
            int n6 = this.currentRGBScaling;
            if (n4 > 0) {
                n2 = aWTBufferList.multiMode[0][n3];
                this.endState();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)GLBase.blendSrcMap[n2], (int)GLBase.blendDstMap[n2]);
                if (n6 != 1) {
                    this.setRGBScaling(1);
                }
                GL11.glDepthMask((boolean)false);
                GL11.glDepthFunc((int)514);
            }
            this.beginState(4);
            if (bl) {
                GL11.glTexCoord2f((float)aWTBufferList.u1[n3], (float)aWTBufferList.v1[n3]);
            }
            if (bl4) {
                for (n2 = 0; n2 < n5; ++n2) {
                    if (aWTBufferList.multiTextures[n2][n3] == null || aWTBufferList.multiTextures[n2][n3].projector != null) continue;
                    ARBMultitexture.glMultiTexCoord2fARB((int)GLBase.stageMap[n2 + 1], (float)aWTBufferList.u1Mul[n2][n3], (float)aWTBufferList.v1Mul[n2][n3]);
                }
            }
            GL11.glColor4f((float)(aWTBufferList.r1[n3] * GLBase.COLOR_INV), (float)(aWTBufferList.g1[n3] * GLBase.COLOR_INV), (float)(aWTBufferList.b1[n3] * GLBase.COLOR_INV), (float)f);
            GL11.glVertex3f((float)aWTBufferList.x1[n3], (float)(-aWTBufferList.y1[n3]), (float)(-aWTBufferList.z1[n3]));
            if (bl) {
                GL11.glTexCoord2f((float)aWTBufferList.u2[n3], (float)aWTBufferList.v2[n3]);
            }
            if (bl4) {
                for (n2 = 0; n2 < n5; ++n2) {
                    if (aWTBufferList.multiTextures[n2][n3] == null || aWTBufferList.multiTextures[n2][n3].projector != null) continue;
                    ARBMultitexture.glMultiTexCoord2fARB((int)GLBase.stageMap[n2 + 1], (float)aWTBufferList.u2Mul[n2][n3], (float)aWTBufferList.v2Mul[n2][n3]);
                }
            }
            GL11.glColor4f((float)(aWTBufferList.r2[n3] * GLBase.COLOR_INV), (float)(aWTBufferList.g2[n3] * GLBase.COLOR_INV), (float)(aWTBufferList.b2[n3] * GLBase.COLOR_INV), (float)f2);
            GL11.glVertex3f((float)aWTBufferList.x2[n3], (float)(-aWTBufferList.y2[n3]), (float)(-aWTBufferList.z2[n3]));
            if (bl) {
                GL11.glTexCoord2f((float)aWTBufferList.u3[n3], (float)aWTBufferList.v3[n3]);
            }
            if (bl4) {
                for (n2 = 0; n2 < n5; ++n2) {
                    if (aWTBufferList.multiTextures[n2][n3] == null || aWTBufferList.multiTextures[n2][n3].projector != null) continue;
                    ARBMultitexture.glMultiTexCoord2fARB((int)GLBase.stageMap[n2 + 1], (float)aWTBufferList.u3Mul[n2][n3], (float)aWTBufferList.v3Mul[n2][n3]);
                }
            }
            GL11.glColor4f((float)(aWTBufferList.r3[n3] * GLBase.COLOR_INV), (float)(aWTBufferList.g3[n3] * GLBase.COLOR_INV), (float)(aWTBufferList.b3[n3] * GLBase.COLOR_INV), (float)f3);
            GL11.glVertex3f((float)aWTBufferList.x3[n3], (float)(-aWTBufferList.y3[n3]), (float)(-aWTBufferList.z3[n3]));
            if (bl3 || n4 > 0) {
                this.endState();
                this.unsetBlendingMode();
                GL11.glDepthMask((boolean)true);
                if (n4 > 0) {
                    GL11.glDepthFunc((int)515);
                    if (n6 != 1) {
                        this.setRGBScaling(n6);
                    }
                }
            }
        }
    }

    public void drawVertexArray(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        if (this.init) {
            this.canvas.add(visList, n, n2, 2);
        }
    }

    void drawVertexArray(AWTDisplayList aWTDisplayList, int n) {
        int n2;
        this.endState();
        this.disableBlitting();
        this.compileDLOrVBO();
        CompiledInstance.lastObj = null;
        this.curPos = 0;
        this.colPos = 0;
        this.texPos = 0;
        this.vertPos = 0;
        if (this.mtTexPos == null) {
            this.mtTexPos = new int[this.minDriverAndConfig];
        }
        for (n2 = 0; n2 < this.mtTexPos.length; ++n2) {
            this.mtTexPos[n2] = 0;
        }
        n2 = 0;
        if (this.init) {
            int n3;
            for (n3 = 0; n3 < this.minDriverAndConfig; ++n3) {
                this.lastIDs[n3] = -9999;
                this.lastMultiTextures[n3] = -9999;
                this.lastMultiModes[n3] = -9999;
            }
            n3 = -9999;
            int n4 = -1;
            if (!this.vertexArraysInitialized) {
                this.initializeVertexArrays();
            }
            AWTBufferList aWTBufferList = aWTDisplayList.vl[n].getFrontBuffer();
            this.wasTransparent = false;
            this.lastTransMode = 0;
            this.lastTexture = -9999;
            int n5 = 0;
            int n6 = 0;
            int n7 = aWTDisplayList.end[n];
            Texture texture = null;
            float[] fArray = aWTBufferList.r1;
            float[] fArray2 = aWTBufferList.r2;
            float[] fArray3 = aWTBufferList.r3;
            float[] fArray4 = aWTBufferList.g1;
            float[] fArray5 = aWTBufferList.g2;
            float[] fArray6 = aWTBufferList.g3;
            float[] fArray7 = aWTBufferList.b1;
            float[] fArray8 = aWTBufferList.b2;
            float[] fArray9 = aWTBufferList.b3;
            float[] fArray10 = aWTBufferList.x1;
            float[] fArray11 = aWTBufferList.x2;
            float[] fArray12 = aWTBufferList.x3;
            float[] fArray13 = aWTBufferList.y1;
            float[] fArray14 = aWTBufferList.y2;
            float[] fArray15 = aWTBufferList.y3;
            float[] fArray16 = aWTBufferList.z1;
            float[] fArray17 = aWTBufferList.z2;
            float[] fArray18 = aWTBufferList.z3;
            float[] fArray19 = aWTBufferList.v1;
            float[] fArray20 = aWTBufferList.v2;
            float[] fArray21 = aWTBufferList.v3;
            float[] fArray22 = aWTBufferList.u1;
            float[] fArray23 = aWTBufferList.u2;
            float[] fArray24 = aWTBufferList.u3;
            float[] fArray25 = aWTBufferList.a1;
            float[] fArray26 = aWTBufferList.a2;
            float[] fArray27 = aWTBufferList.a3;
            Texture[] textureArray = aWTBufferList.texture;
            boolean[] blArray = aWTBufferList.trans;
            boolean[] blArray2 = aWTBufferList.multi;
            int[] nArray = aWTBufferList.maxStages;
            int[] nArray2 = aWTBufferList.stageCnt;
            int n8 = this.currentRGBScaling;
            int[] nArray3 = this.ambient;
            float[] fArray28 = new float[3];
            float[] fArray29 = new float[4];
            for (int i = 0; i < 3; ++i) {
                fArray28[i] = (float)nArray3[i] * GLBase.COLOR_INV;
                if (!(fArray28[i] < 0.0f)) continue;
                fArray28[i] = 0.0f;
            }
            ((Buffer)this.ambientBuffer).rewind();
            this.ambientBuffer.put(fArray28);
            this.ambientBuffer.put(1.0f);
            Serializable serializable = null;
            Object[] objectArray = null;
            Matrix matrix = null;
            this.blending = false;
            for (int i = 0; i <= n7; ++i) {
                Serializable serializable2;
                int n9;
                boolean bl;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                n5 = n6;
                n6 = nArray2[i];
                if (aWTBufferList.r3[i] == -1000000.0f) {
                    bl4 = true;
                }
                n3 = n4 = i - 1;
                texture = textureArray[i];
                boolean bl5 = texture.projector == null;
                float f = 1.0f;
                float f2 = 1.0f;
                float f3 = 1.0f;
                boolean bl6 = blArray[i];
                int n10 = aWTBufferList.transValue[i] >> 16;
                boolean bl7 = blArray2[i];
                int n11 = nArray[i];
                if (n11 > this.minDriverAndConfig) {
                    n11 = this.minDriverAndConfig;
                }
                if (bl6) {
                    if (fArray25 == null || fArray25[i] == -1.0f) {
                        f = Config.glTransparencyOffset + (float)(aWTBufferList.transValue[i] & 0xFFFF) * Config.glTransparencyMul;
                        if (f > 1.0f) {
                            f = 1.0f;
                        }
                        f2 = f;
                        f3 = f;
                    } else {
                        f = fArray25[i];
                        f2 = fArray26[i];
                        f3 = fArray27[i];
                    }
                }
                boolean bl8 = bl = texture.getOpenGLID(this.myID) != this.lastTexture;
                if (this.lastCoords != this.veryLastCoords) {
                    this.enableVertexArrays(this.lastCoords, this.veryLastCoords);
                }
                this.veryLastCoords = this.lastCoords;
                this.lastCoords = 1;
                if (bl7) {
                    for (n9 = 1; n9 < n11 && aWTBufferList.multiTextures[n9 - 1][i] != null; ++n9) {
                        ++this.lastCoords;
                    }
                }
                if (!bl) {
                    bl |= texture.getOpenGLID(this.myID) == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD;
                    bl |= this.lastCoords != this.veryLastCoords;
                    bl |= n4 != -1 && n11 != nArray[n4];
                    bl |= n5 != n6;
                }
                if (!bl && bl7) {
                    for (n9 = 1; n9 < n11; ++n9) {
                        serializable2 = aWTBufferList.multiTextures[n9 - 1][i];
                        if (serializable2 != null) {
                            if (serializable2.getOpenGLID(this.myID) == this.lastMultiTextures[n9] && aWTBufferList.multiMode[n9 - 1][i] == this.lastMultiModes[n9] && serializable2.getOpenGLID(this.myID) != 0 && serializable2.getMarker(this.myID) != Texture.MARKER_DELETE_AND_UPLOAD) continue;
                            bl = true;
                            break;
                        }
                        if (this.lastMultiTextures[n9] == -1 || this.lastMultiTextures[n9] == -9999) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl4 && this.curPos != 0 || bl6 != this.wasTransparent || n10 != this.lastTransMode || bl || this.curPos >= 997) {
                    if (i != 0) {
                        if (n2 != 0) {
                            this.disableCompiledPipeline();
                            this.renableVertexArrays();
                            n2 = 0;
                        }
                        if (this.wasTransparent) {
                            this.setBlendingMode(this.lastTransMode);
                            if (n5 == 0) {
                                this.setDepthBuffer();
                            }
                            bl2 = true;
                        }
                        if (n5 > 0) {
                            n9 = this.lastMultiModes[1];
                            GL11.glEnable((int)3042);
                            GL11.glBlendFunc((int)GLBase.blendSrcMap[n9], (int)GLBase.blendDstMap[n9]);
                            if (n8 != 1) {
                                this.setRGBScaling(1);
                            }
                            GL11.glDepthMask((boolean)false);
                            GL11.glDepthFunc((int)514);
                            bl3 = true;
                        }
                        this.setTextures(aWTBufferList, n3, this.cam, null);
                        this.renderVertexArray(this.curPos);
                    }
                    this.wasTransparent = bl6;
                    this.lastTransMode = n10;
                    this.curPos = 0;
                    this.colPos = 0;
                    this.texPos = 0;
                    this.vertPos = 0;
                    for (n9 = 0; n9 < this.mtTexPos.length; ++n9) {
                        this.mtTexPos[n9] = 0;
                    }
                    if (n6 > 0) {
                        this.lastMultiModes[1] = aWTBufferList.multiMode[0][i];
                    }
                    this.lastTexture = texture.getOpenGLID(this.myID);
                    for (n9 = 1; n9 < n11; ++n9) {
                        serializable2 = aWTBufferList.multiTextures[n9 - 1][i];
                        if (serializable2 != null) {
                            this.lastMultiTextures[n9] = serializable2.getOpenGLID(this.myID);
                            this.lastMultiModes[n9] = aWTBufferList.multiMode[n9 - 1][i];
                            continue;
                        }
                        this.lastMultiTextures[n9] = -9999;
                        this.lastMultiModes[n9] = -9999;
                    }
                }
                if (bl4) {
                    if (bl2 || bl3) {
                        this.blending = false;
                        this.unsetBlendingMode();
                        GL11.glDepthMask((boolean)true);
                        bl2 = false;
                        if (bl3) {
                            bl3 = false;
                            GL11.glDepthFunc((int)515);
                            if (n8 != 1) {
                                this.setRGBScaling(n8);
                            }
                        }
                    }
                    if (n2 == 0) {
                        this.enableCompiledPipeline();
                    }
                    if (bl6) {
                        if (!this.blending) {
                            this.setBlendingMode(n10);
                        }
                        bl2 = true;
                        if (n6 == 0) {
                            if (!this.blending) {
                                this.setDepthBuffer();
                            }
                            if (i < n7 && aWTBufferList.r3[i + 1] == -1000000.0f && blArray[i + 1] == bl6 && aWTBufferList.transValue[i + 1] >> 16 == n10) {
                                bl2 = false;
                                this.blending = true;
                            }
                        }
                    }
                    if (n6 > 0) {
                        n9 = aWTBufferList.multiMode[0][i];
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)GLBase.blendSrcMap[n9], (int)GLBase.blendDstMap[n9]);
                        if (n8 != 1) {
                            this.setRGBScaling(1);
                        }
                        GL11.glDepthMask((boolean)false);
                        GL11.glDepthFunc((int)514);
                        bl3 = true;
                    }
                    fArray29[0] = aWTBufferList.r1[i] * GLBase.COLOR_INV;
                    fArray29[1] = aWTBufferList.g1[i] * GLBase.COLOR_INV;
                    fArray29[2] = aWTBufferList.b1[i] * GLBase.COLOR_INV;
                    fArray29[3] = f;
                    n2 = 1;
                    CompiledInstance compiledInstance = (CompiledInstance)aWTBufferList.cis.get((int)aWTBufferList.r2[i]);
                    serializable2 = compiledInstance.obj;
                    if (serializable2 != serializable) {
                        serializable = serializable2;
                        objectArray = (Object[])aWTBufferList.obj2Matrix.get(serializable2);
                        matrix = (Matrix)aWTBufferList.obj2textureMatrix.get(serializable2);
                    }
                    this.setTextures(aWTBufferList, i, this.cam, matrix);
                    this.clearHook(((Object3D)serializable2).renderHook);
                    compiledInstance.render(this.myID, this, this.ambientBuffer, fArray29, this.renderTarget != null && this.renderTarget.isShadowMap, this.cam, (float[][])aWTBufferList.lights[i], false, objectArray);
                    this.curPos = 0;
                    this.colPos = 0;
                    this.texPos = 0;
                    for (int j = 0; j < this.mtTexPos.length; ++j) {
                        this.mtTexPos[j] = 0;
                    }
                    this.vertPos = 0;
                } else {
                    this.colors.put(this.colPos, fArray[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 1, fArray4[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 2, fArray7[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 3, f);
                    this.colPos += 4;
                    this.vertices.put(this.vertPos, fArray10[i]);
                    this.vertices.put(this.vertPos + 1, -fArray13[i]);
                    this.vertices.put(this.vertPos + 2, -fArray16[i]);
                    this.vertPos += 3;
                    if (bl5) {
                        this.textures.put(this.texPos, fArray22[i]);
                        this.textures.put(this.texPos + 1, fArray19[i]);
                        this.texPos += 2;
                    }
                    if (bl7) {
                        for (n9 = 1; n9 < n11; ++n9) {
                            int n12 = n9 - 1;
                            if (aWTBufferList.multiTextures[n12][i] == null || aWTBufferList.multiTextures[n12][i].projector != null) continue;
                            FloatBuffer floatBuffer = this.multiTextures[n9];
                            int n13 = this.mtTexPos[n9];
                            floatBuffer.put(n13, aWTBufferList.u1Mul[n12][i]);
                            floatBuffer.put(n13 + 1, aWTBufferList.v1Mul[n12][i]);
                            floatBuffer.put(n13 + 2, aWTBufferList.u2Mul[n12][i]);
                            floatBuffer.put(n13 + 3, aWTBufferList.v2Mul[n12][i]);
                            floatBuffer.put(n13 + 4, aWTBufferList.u3Mul[n12][i]);
                            floatBuffer.put(n13 + 5, aWTBufferList.v3Mul[n12][i]);
                            int n14 = n9;
                            this.mtTexPos[n14] = this.mtTexPos[n14] + 6;
                        }
                    }
                    ++this.curPos;
                    this.colors.put(this.colPos, fArray2[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 1, fArray5[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 2, fArray8[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 3, f2);
                    this.colPos += 4;
                    this.vertices.put(this.vertPos, fArray11[i]);
                    this.vertices.put(this.vertPos + 1, -fArray14[i]);
                    this.vertices.put(this.vertPos + 2, -fArray17[i]);
                    this.vertPos += 3;
                    if (bl5) {
                        this.textures.put(this.texPos, fArray23[i]);
                        this.textures.put(this.texPos + 1, fArray20[i]);
                        this.texPos += 2;
                    }
                    ++this.curPos;
                    this.colors.put(this.colPos, fArray3[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 1, fArray6[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 2, fArray9[i] * GLBase.COLOR_INV);
                    this.colors.put(this.colPos + 3, f3);
                    this.colPos += 4;
                    this.vertices.put(this.vertPos, fArray12[i]);
                    this.vertices.put(this.vertPos + 1, -fArray15[i]);
                    this.vertices.put(this.vertPos + 2, -fArray18[i]);
                    this.vertPos += 3;
                    if (bl5) {
                        this.textures.put(this.texPos, fArray24[i]);
                        this.textures.put(this.texPos + 1, fArray21[i]);
                        this.texPos += 2;
                    }
                    ++this.curPos;
                    if (n7 == i) {
                        if (n2 != 0) {
                            this.disableCompiledPipeline();
                            this.renableVertexArrays();
                            n2 = 0;
                        }
                        if (bl6) {
                            this.setBlendingMode(n10);
                            if (n6 == 0) {
                                this.setDepthBuffer();
                            }
                            this.wasTransparent = bl6;
                            this.lastTransMode = n10;
                            bl2 = true;
                        }
                        if (n6 > 0) {
                            n9 = aWTBufferList.multiMode[0][i];
                            GL11.glEnable((int)3042);
                            GL11.glBlendFunc((int)GLBase.blendSrcMap[n9], (int)GLBase.blendDstMap[n9]);
                            if (n8 != 1) {
                                this.setRGBScaling(1);
                            }
                            GL11.glDepthMask((boolean)false);
                            GL11.glDepthFunc((int)514);
                            bl3 = true;
                        }
                        this.setTextures(aWTBufferList, i, this.cam, null);
                        this.renderVertexArray(this.curPos);
                        this.curPos = 0;
                        this.colPos = 0;
                        this.texPos = 0;
                        this.vertPos = 0;
                        for (n9 = 0; n9 < this.mtTexPos.length; ++n9) {
                            this.mtTexPos[n9] = 0;
                        }
                    }
                }
                if (!bl2 && !bl3) continue;
                this.blending = false;
                this.unsetBlendingMode();
                GL11.glDepthMask((boolean)true);
                if (!bl3) continue;
                GL11.glDepthFunc((int)515);
                if (n8 == 1) continue;
                this.setRGBScaling(n8);
            }
        }
        this.setTextureMatrix(null);
        this.matrixCache.clear();
        if (n2 != 0) {
            this.disableCompiledPipeline();
            this.renableVertexArrays();
        }
        CompiledInstance.lastObj = null;
    }

    public void drawWireframe(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        if (this.init) {
            this.canvas.add(visList, n, n, 5);
            this.canvas.setColor(n2);
        }
    }

    void drawWireframe(AWTDisplayList aWTDisplayList, int n) {
        if (this.init) {
            this.endState();
            this.disableBlitting();
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            this.disableAllHigherStages();
            this.beginState(4);
            int n2 = aWTDisplayList.getColor();
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            int n6 = aWTDisplayList.start[n];
            AWTBufferList aWTBufferList = aWTDisplayList.vl[n].getFrontBuffer();
            GL11.glColor3f((float)((float)n3 / 255.0f), (float)((float)n4 / 255.0f), (float)((float)n5 / 255.0f));
            int n7 = aWTBufferList.stageCnt[n6];
            boolean bl = false;
            if (aWTBufferList.r3[n6] == -1000000.0f) {
                bl = true;
            }
            if (!bl) {
                GL11.glVertex3f((float)aWTBufferList.x1[n6], (float)(-aWTBufferList.y1[n6]), (float)(-aWTBufferList.z1[n6]));
                GL11.glVertex3f((float)aWTBufferList.x2[n6], (float)(-aWTBufferList.y2[n6]), (float)(-aWTBufferList.z2[n6]));
                GL11.glVertex3f((float)aWTBufferList.x3[n6], (float)(-aWTBufferList.y3[n6]), (float)(-aWTBufferList.z3[n6]));
            } else {
                CompiledInstance compiledInstance = (CompiledInstance)aWTBufferList.cis.get((int)aWTBufferList.r2[n6]);
                compiledInstance.render(this.myID, this, null, null, false, this.cam, null, true, (Object[])aWTBufferList.obj2Matrix.get(compiledInstance.obj));
                this.disableCompiledPipeline();
                this.renableVertexArrays();
                this.matrixCache.clear();
            }
            this.endState();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3553);
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    private void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    private void setTextureProjector(Projector projector, Texture texture) {
        texture.projectorBuffer = projector;
    }

    private void bufferTextureProjectors() {
        Texture[] textureArray = this.texMan.getTextures();
        for (int i = 0; i < textureArray.length; ++i) {
            Texture texture = textureArray[i];
            if (texture == null) continue;
            Projector projector = texture.projector;
            if (projector != null && texture.enabled) {
                Projector projector2 = new Projector();
                projector2.setBack(projector.getBack().cloneMatrix());
                projector2.setPosition(projector.getPosition());
                projector2.setFOVLimits(projector.getMinFOV(), projector.getMaxFOV());
                projector2.setFOV(projector.getFOV());
                projector2.setYFOV(projector.getYFOV());
                Object[] objectArray = new Object[]{projector2, texture};
                this.canvas.add(22, objectArray);
                continue;
            }
            if (projector != null) continue;
            texture.projectorBuffer = null;
        }
    }

    private Texture setTextures(AWTBufferList aWTBufferList, int n, Camera camera, Matrix matrix) {
        boolean bl = false;
        Texture texture = aWTBufferList.texture[n];
        if (texture.getOpenGLID(this.myID) == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
            texture.setMarker(this.myID, Texture.MARKER_NOTHING);
            this.endState();
            if (texture != this.renderTarget) {
                if (texture.getOpenGLID(this.myID) != 0) {
                    this.removeTexture(texture);
                }
                this.convertTexture(texture);
            }
            this.lastTextures[0] = -1;
        }
        bl = texture.isShadowMap;
        this.setTextureMatrix(matrix);
        this.bindAndProject(0, texture, camera);
        if (aWTBufferList.multi[n]) {
            if (this.maxStages < aWTBufferList.maxStages[n]) {
                this.maxStages = aWTBufferList.maxStages[n];
                if (this.maxStages > this.minDriverAndConfig) {
                    this.maxStages = this.minDriverAndConfig;
                }
            }
            for (int i = 1; i < this.maxStages; ++i) {
                int n2 = i - 1;
                Texture texture2 = aWTBufferList.multiTextures[n2][n];
                if (texture2 != null) {
                    bl |= texture2.isShadowMap;
                    int n3 = GLBase.modeMap[aWTBufferList.multiMode[n2][n]];
                    if (!this.stageInitialized[i]) {
                        this.initTextureStage(i, n3);
                    } else {
                        this.switchTextureMode(i, n3);
                    }
                    int n4 = texture2.getOpenGLID(this.myID);
                    if (n4 == 0 || texture2.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
                        texture2.setMarker(this.myID, Texture.MARKER_NOTHING);
                        this.endState();
                        if (texture2 != this.renderTarget) {
                            if (n4 != 0) {
                                this.removeTexture(texture2);
                            }
                            this.convertTexture(texture2);
                        }
                        this.lastTextures[i] = -1;
                    }
                    this.bindAndProject(i, texture2, camera);
                    continue;
                }
                this.disableStage(i);
            }
        } else {
            this.disableUnusedStages();
        }
        if (!bl) {
            this.disableGlobalAlphaTest();
        }
        return texture;
    }
}

